<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DynamicSlidingWindow.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

class JCAT_DynamicSlidingWindow extends JCAT_SlidingWindowBase
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @param	$nSize	int
	 * @return	void
	 */
	public function JCAT_DynamicSlidingWindow( $nSize=9 )
	{
		$this->SetWindowSize($nSize) ;
	}

	/**
	 * 设置 窗口尺寸
	 *
	 * @access	public
	 * @param	$nSize	int		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetWindowSize( $nSize )
	{
		JCAT_ASSERT::ASSERT_($nSize%2==1,JCAT_Language::SentenceEx('JCAT_DynamicSlidingWindow 滑动窗口的尺寸必须单数; 传入值为：%d。','JCAT',null,$nSize))  ;
		return parent::SetWindowSize( $nSize ) ;
	}
	
	/**
	 * 计算窗口边界
	 *
	 * @access	public
	 * @return	array:int
	 */
	public function GetWindowBundary()
	{
		$nCurrentPosition = $this->GetPosition() ;
		$nWindowSize = $this->GetWindowSize() ;
		$nHalfSize = ($nWindowSize-1)/2 ;
		
		list($nRangStart,$nRangEnd) = $this->GetSlideRange() ;
		$nRang = $nRangEnd - $nRangStart + 1 ;
		// 无范围
		if($nRang<=0)
		{
			return array($nRangStart,$nRangStart) ;
		}
				
		$nWindowStart = $nCurrentPosition - $nHalfSize ;
		$nWindowEnd = $nCurrentPosition + $nHalfSize ;
		
		// 确保 窗口边界 的有效值
		if( $nRangEnd<$nWindowEnd )
		{
			$nWindowEnd = $nRangEnd ;
		}
		if( $nRangStart>$nWindowStart )
		{
			$nWindowStart = $nRangStart ;
		}
		
		return array($nWindowStart,$nWindowEnd) ;
	}

	/**
	 * 向前滑动窗口，取回新的位置
	 *
	 * @access	public
	 * @param 	$bJustTest=false	bool
	 * @return	int
	 */
	public function SlideForward($bJustTest=false)
	{
		$nCurrentPosition = $this->GetPosition() ;
		$nWindowSize = $this->GetWindowSize() ;
		$nPosition = $nCurrentPosition + $nWindowSize ;
		
		list(,$nRangEnd) = $this->GetSlideRange() ;
		if($nPosition>$nRangEnd)
		{
			$nPosition = $nRangEnd ;
		}
		
		if(!$bJustTest)
		{
			$this->SetPosition($nPosition) ;
		}
		
		return $nPosition ;
	}
	
	/**
	 * 向后滑动窗口，取回新的位置
	 *
	 * @access	public
	 * @param 	$bJustTest=false	bool
	 * @return	int
	 */
	public function SlideBackward($bJustTest=false)
	{
		$nCurrentPosition = $this->GetPosition() ;
		$nWindowSize = $this->GetWindowSize() ;
		$nPosition = $nCurrentPosition - $nWindowSize ;
		
		list($nRangStart,) = $this->GetSlideRange() ;
		if($nPosition<$nRangStart)
		{
			$nPosition = $nRangStart ;
		}
		
		if(!$bJustTest)
		{
			$this->SetPosition($nPosition) ;
		}
		
		return $nPosition ;		
	}
}
?>