<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_SlidingWindowBase.php 1878 2009-05-28 08:34:16Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

abstract class JCAT_SlidingWindowBase
	implements JCAT_ISlidingWindow
{
	/**
	 * 设置 窗口尺寸
	 *
	 * @access	public
	 * @param	$nSize	int		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetWindowSize( $nSize )
	{
		JCAT_ASSERT::ASSERT_INT($nSize) ;
		JCAT_ASSERT::ASSERT_($nSize>0,JCAT_Language::SentenceEx('滑动窗口的尺寸必须为有效的正整数。','JCAT',null))  ;

		$old_value = $this->nSlidingWindowSize ;
		$this->nSlidingWindowSize = $nSize ;
		return $old_value ;
	}
	
	
	/**
	 * 取得 窗口尺寸
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetWindowSize()
	{
		return $this->nSlidingWindowSize ;		
	}

	/**
	 * 设置位置
	 *
	 * @access	public
	 * @param	$nPosition	int		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetPosition( $nPosition )
	{
		JCAT_ASSERT::ASSERT_INT($nPosition) ;
		JCAT_ASSERT::ASSERT_INRANGE($nPosition,$this->nSlideRangStart,$this->nSlideRangEnd
				, JCAT_Language::SentenceEx('位置必须设置在滑动范围内（%s - %s）。','JCAT',null,$this->nSlideRangStart,$this->nSlideRangEnd))  ;

		$old_value = $this->nCurrentPosition ;
		$this->nCurrentPosition = $nPosition ;
		return $old_value ;
	}
	
	
	/**
	 * 取得 位置
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPosition()
	{
		return $this->nCurrentPosition ;		
	}
	
	/**
	 * 设置滑动范围
	 *
	 * @access	public
	 * @param	$nSlideRangStart	int		What's this Parameter ?
	 * @param	$nSlideRangEnd		int		What's this Parameter ?
	 * @return	void
	 */
	public function SetSlideRange($nSlideRangStart,$nSlideRangEnd)
	{
		JCAT_ASSERT::ASSERT_INT($nSlideRangStart) ;
		JCAT_ASSERT::ASSERT_INT($nSlideRangEnd) ;
		
		$this->nSlideRangStart = $nSlideRangStart ;
		$this->nSlideRangEnd = $nSlideRangEnd ;
	}

	/**
	 * 取回滑动范围
	 *
	 * @access	public
	 * @return	array:int
	 */
	public function GetSlideRange()
	{
		return array( $this->nSlideRangStart ,$this->nSlideRangEnd ) ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 滑动窗口的尺寸
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nSlidingWindowSize = 0 ;
	
	/**
	 * 当前位置
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nCurrentPosition = 1 ;
	
	/**
	 * 起点
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nSlideRangStart = 1 ;
	
	/**
	 * 终点
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nSlideRangEnd = 0 ;
}
?>