<?php


interface JCAT_ISlidingWindow
{
	/**
	 * 设置 窗口尺寸
	 *
	 * @access	public
	 * @param	$nSize	int		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetWindowSize( $nSize ) ;
	
	
	/**
	 * 取得 窗口尺寸
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetWindowSize() ;
	
	/**
	 * 计算窗口边界
	 *
	 * @access	public
	 * @return	array:int
	 */
	public function GetWindowBundary() ;
	
	/**
	 * 向前滑动窗口，取回新的位置
	 *
	 * @access	public
	 * @param 	$bJustTest=false	bool
	 * @return	int
	 */
	public function SlideForward($bJustTest=false) ;
	
	/**
	 * 向后滑动窗口，取回新的位置
	 *
	 * @access	public
	 * @param 	$bJustTest=false	bool
	 * @return	int
	 */
	public function SlideBackward($bJustTest=false) ;

	/**
	 * 设置位置
	 *
	 * @access	public
	 * @param	$nPosition	int		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetPosition( $nPosition ) ;
	
	
	/**
	 * 取得 位置
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPosition() ;
	
	/**
	 * 设置滑动范围
	 *
	 * @access	public
	 * @param	$nSlideRangStart	int		What's this Parameter ?
	 * @param	$nSlideRangEnd		int		What's this Parameter ?
	 * @return	void
	 */
	public function SetSlideRange($nSlideRangStart,$nSlideRangEnd) ;

	/**
	 * 取回滑动范围
	 *
	 * @access	public
	 * @return	array:int
	 */
	public function GetSlideRange() ;
}

?>
