<?php
// Call JCAT_UIObjectTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_UIObjectTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/UI/class.JCAT_UIObject.php';
require_once '/home/alee/桌面/lib.php/Common/UI/UIHtml/class.JCAT_UIHtmlNode.php';

/**
 * Test class for JCAT_UIObject.
 * Generated by PHPUnit on 2007-12-28 at 12:16:51.
 */
class JCAT_UIObjectTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_UIObjectTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testSetTemplate().
     */
    public function testThis() {
        		
		$aTopUIOb = new JCAT_UIObject('TOP') ;
		$aTopUIOb->SetStartByte(0) ;
		$aTopUIOb->SetEndByte(999999) ;
		
		$this->assertEquals( $aTopUIOb->GetStartByte(), 0 ) ;
		$this->assertEquals( $aTopUIOb->GetEndByte(), 999999 ) ;
		$this->assertEquals($aTopUIOb->GetSource(),'TOP') ;
		
		/*
		用例
		
		[a]:1-10
			
			[b]:2-3
			[c]:4-9
				[d]:5-7
			9
		10
		
		[e]:17-80
			[f]:19-32
			[g]:40-60
				[h]:40-50			// 与上级 同 起点
			60
		80
		
		[i]:120-200
			[j]:170-190
		200
		
		[k]:300-500
			[l]:400-500				// 与上级 同 终点
				[m]:400-500			// 与上级 同 起点 同 终点
			500		
		500
		
		*/
		
		$aUIObjectA = new JCAT_UIObject('A') ;
		$aUIObjectA->SetStartByte(1) ;
		$aUIObjectA->SetEndByte(10) ;
		
		$aUIObjectB = new JCAT_UIObject('B') ;
		$aUIObjectB->SetStartByte(2) ;
		$aUIObjectB->SetEndByte(3) ;
		
		$aUIObjectC = new JCAT_UIObject('C') ;
		$aUIObjectC->SetStartByte(4) ;
		$aUIObjectC->SetEndByte(9) ;
		
		$aUIObjectD = new JCAT_UIObject('D') ;
		$aUIObjectD->SetStartByte(5) ;
		$aUIObjectD->SetEndByte(7) ;
		
		$aUIObjectE = new JCAT_UIObject('E') ;
		$aUIObjectE->SetStartByte(17) ;
		$aUIObjectE->SetEndByte(80) ;
		
		$aUIObjectF = new JCAT_UIObject('F') ;
		$aUIObjectF->SetStartByte(19) ;
		$aUIObjectF->SetEndByte(32) ;
		
		$aUIObjectG = new JCAT_UIObject('G') ;
		$aUIObjectG->SetStartByte(40) ;
		$aUIObjectG->SetEndByte(60) ;
		
		$aUIObjectH = new JCAT_UIObject('H') ;
		$aUIObjectH->SetStartByte(40) ;
		$aUIObjectH->SetEndByte(50) ;
		
		$aUIObjectI = new JCAT_UIObject('I') ;
		$aUIObjectI->SetStartByte(120) ;
		$aUIObjectI->SetEndByte(200) ;
		
		$aUIObjectJ = new JCAT_UIObject('J') ;
		$aUIObjectJ->SetStartByte(170) ;
		$aUIObjectJ->SetEndByte(190) ;
		
		$aUIObjectK = new JCAT_UIObject('K') ;
		$aUIObjectK->SetStartByte(300) ;
		$aUIObjectK->SetEndByte(500) ;
		
		$aUIObjectL = new JCAT_UIObject('L') ;
		$aUIObjectL->SetStartByte(400) ;
		$aUIObjectL->SetEndByte(500) ;
		
		$aUIObjectM = new JCAT_UIObject('M') ;
		$aUIObjectM->SetStartByte(400) ;
		$aUIObjectM->SetEndByte(500) ;
		
		
		
		$aTopUIOb->AddUIObject($aUIObjectA) ;
		$aTopUIOb->AddUIObject($aUIObjectB) ;
		$aTopUIOb->AddUIObject($aUIObjectC) ;
		$aTopUIOb->AddUIObject($aUIObjectD) ;
		$aTopUIOb->AddUIObject($aUIObjectE) ;
		$aTopUIOb->AddUIObject($aUIObjectF) ;
		$aTopUIOb->AddUIObject($aUIObjectG) ;
		$aTopUIOb->AddUIObject($aUIObjectH) ;
		$aTopUIOb->AddUIObject($aUIObjectI) ;
		$aTopUIOb->AddUIObject($aUIObjectJ) ;
		$aTopUIOb->AddUIObject($aUIObjectK) ;
		$aTopUIOb->AddUIObject($aUIObjectL) ;
		$aTopUIOb->AddUIObject($aUIObjectM) ;
		
		
		$aIterator = $aTopUIOb->CreateUIObjectIterator() ;								// 第一层
		
		
		$this->assertEquals($aIterator->Current()->GetSource(),'A') ;
		$aIteratorLevel2 = $aIterator->Current()->CreateUIObjectIterator() ;			// 第二层
		$this->assertEquals($aIteratorLevel2->Current()->GetSource(),'B') ;		
		$this->assertEquals($aIteratorLevel2->Next()->GetSource(),'C') ;
		$aIteratorLevel3 = $aIteratorLevel2->Current()->CreateUIObjectIterator() ;		// 第三层
		$this->assertEquals($aIteratorLevel3->Current()->GetSource(),'D') ;
		$this->assertEquals($aIteratorLevel3->Next(),null) ;
		$this->assertTrue($aIteratorLevel3->IsDone()) ;
		$this->assertEquals($aIteratorLevel2->Next(),null) ;
		$this->assertTrue($aIteratorLevel2->IsDone()) ;

		
		$this->assertEquals($aIterator->Next()->GetSource(),'E') ;
		$aIteratorLevel2 = $aIterator->Current()->CreateUIObjectIterator() ;			// 第二层
		$this->assertEquals($aIteratorLevel2->Current()->GetSource(),'F') ;		
		$this->assertEquals($aIteratorLevel2->Next()->GetSource(),'G') ;
		$aIteratorLevel3 = $aIteratorLevel2->Current()->CreateUIObjectIterator() ;		// 第三层
		$this->assertEquals($aIteratorLevel3->Current()->GetSource(),'H') ;
		$this->assertEquals($aIteratorLevel3->Next(),null) ;
		$this->assertTrue($aIteratorLevel3->IsDone()) ;
		$this->assertEquals($aIteratorLevel2->Next(),null) ;
		$this->assertTrue($aIteratorLevel2->IsDone()) ;
		
		
		$this->assertEquals($aIterator->Next()->GetSource(),'I') ;
		
		$this->assertEquals($aIterator->Next()->GetSource(),'K') ;
		$aIteratorLevel2 = $aIterator->Current()->CreateUIObjectIterator() ;			// 第二层
		$this->assertEquals($aIteratorLevel2->Current()->GetSource(),'L') ;
		$aIteratorLevel3 = $aIteratorLevel2->Current()->CreateUIObjectIterator() ;		// 第三层
		$this->assertEquals($aIteratorLevel3->Current()->GetSource(),'M') ;
		$this->assertEquals($aIteratorLevel3->Next(),null) ;
		$this->assertTrue($aIteratorLevel3->IsDone()) ;
		$this->assertEquals($aIteratorLevel2->Next(),null) ;
		$this->assertTrue($aIteratorLevel2->IsDone()) ;
		
		// 
		$this->assertEquals($aIterator->Next(),null) ;
		$this->assertTrue($aIterator->IsDone()) ;
    }
	
	
    /**
     * @todo Implement testSetTemplate().
     */
    public function testLocate() {
	
		$sSource = "
strrpos[(Link)] --  Find position of last occurrence of a char in a string 
Description
int strrpos[(Link)] ( string haystack, string needle [, int offset] ) 
{+++
Function Prototype
+++}

中文内容
Returns the numeric position of the last occurrence of needle in the haystack string.
Note that the needle in this case can only be a single character in PHP 4[(Link)]. 
" ;
		
		// 从原文中 定位 多处 "[(Link)]"
		$nFindStart = 0 ;
		$aLink_1 = new JCAT_UIObject('[(Link)]') ;
		$aLink_2 = new JCAT_UIObject('[(Link)]') ;
		$aLink_3 = new JCAT_UIObject('[(Link)]') ;
		
		$aLink_1->Locate(&$sSource,$nFindStart) ;
		$nFindStart = $aLink_1->GetEndByte() + 1 ;
		
		$aLink_2->Locate(&$sSource,$nFindStart) ;
		$nFindStart = $aLink_2->GetEndByte() + 1 ;
		
		$aLink_3->Locate(&$sSource,$nFindStart) ;
		
		$this->assertEquals($aLink_1->GetStartByte(),8) ;
		$this->assertEquals($aLink_1->GetEndByte(),15) ;
		$this->assertEquals($aLink_1->GetStartLine(),1) ;
		$this->assertEquals($aLink_1->GetEndLine(),1) ;
		$this->assertEquals($aLink_1->GetStartByteInLine(),7) ;
		$this->assertEquals($aLink_1->GetEndByteInLine(),14) ;
		
		$this->assertEquals($aLink_2->GetStartByte(),100) ;
		$this->assertEquals($aLink_2->GetEndByte(),107) ;
		$this->assertEquals($aLink_2->GetStartLine(),3) ;
		$this->assertEquals($aLink_2->GetEndLine(),3) ;
		$this->assertEquals($aLink_2->GetStartByteInLine(),11) ;
		$this->assertEquals($aLink_2->GetEndByteInLine(),18) ;
		
		$this->assertEquals($aLink_3->GetStartByte(),362) ;
		$this->assertEquals($aLink_3->GetEndByte(),369) ;
		$this->assertEquals($aLink_3->GetStartLine(),10) ;
		$this->assertEquals($aLink_3->GetEndLine(),10) ;
		$this->assertEquals($aLink_3->GetStartByteInLine(),73) ;
		$this->assertEquals($aLink_3->GetEndByteInLine(),80) ;
		
		// 夸行的 内容
		$aFunctionPrototype = new JCAT_UIObject('{+++
Function Prototype
+++}') ;
		$aFunctionPrototype->Locate(&$sSource,0) ;
		
		$this->assertEquals($aFunctionPrototype->GetStartByte(),160) ;
		$this->assertEquals($aFunctionPrototype->GetEndByte(),187) ;
		$this->assertEquals($aFunctionPrototype->GetStartLine(),4) ;
		$this->assertEquals($aFunctionPrototype->GetEndLine(),6) ;
		$this->assertEquals($aFunctionPrototype->GetStartByteInLine(),0) ;
		$this->assertEquals($aFunctionPrototype->GetEndByteInLine(),3) ;
		
		

	}
	
	
	function testAddUIObject()
	{
		$sTemplate = "Returns the numeric position of the last occurrence of needle in the haystack string.
Note that the needle in this case can only be a single character in PHP 4[(Link)]. 
If a string is passed as the needle, then only the first character of that string will be used.
<IF '\$nCode==10'>

{& HI! &}

<ELSE>


</IF>
strrpos[(Link)] --  Find position of last occurrence of a char in a string 
Description
int strrpos[(Link)] ( string haystack, string needle [, int offset] ) 

<ui:date format='Y\.m\.d G:i:s' time='GetTime()' hi  'hiii~~~\'~~'  yy='/?:---\"--\'---:/' />
<continue>

<if '/~:\$s==ssss:/'>

	<UI:DO While='\$aCondition'>
		<Print \$aCondition />
	</UI>

<elseif \$sN>

<else2>
/?:echo \$cc:/

</if>

" ;
	
		$aTop = new JCAT_UIObject($sTemplate) ;
		
		$aNode_1 = new JCAT_UIHtmlNode("<IF '\$nCode==10'>

{& HI! &}

<ELSE>


</IF>", 'if') ;
		$aNode_2 = new JCAT_UIHtmlNode("<ELSE>",'else') ;
		$aNode_3 = new JCAT_UIObject("{& HI! &}") ;
		
		$aNode_4 = new JCAT_UIHtmlNode("<if '/~:\$s==ssss:/'>

	<UI:DO While='\$aCondition'>
		<Print \$aCondition />
	</UI>

<elseif \$sN>

<else2>
/?:echo \$cc:/

</if>", 'if') ;
		$aNode_5 = new JCAT_UIHtmlNode("<elseif \$sN>", 'elseif') ;
		$aNode_6 = new JCAT_UIHtmlNode("<else2>", 'else2') ;
		
		$aTop ->Locate(&$sTemplate,0) ;
		$aNode_1->Locate(&$sTemplate,0) ;
		$aNode_2->Locate(&$sTemplate,0) ;
		$aNode_3->Locate(&$sTemplate,0) ;
		$aNode_4->Locate(&$sTemplate,0) ;
		$aNode_5->Locate(&$sTemplate,0) ;
		$aNode_6->Locate(&$sTemplate,0) ;
		
		$aTop->AddUIObject($aNode_3) ;
		$aTop->AddUIObject($aNode_1) ;
		$aTop->AddUIObject($aNode_2) ;
		
		$aTop->AddUIObject($aNode_6) ;
		$aTop->AddUIObject($aNode_5) ;
		$aTop->AddUIObject($aNode_4) ;//print_r($aTop) ;
		
		
		// $aTop ->_PrintUIObjectsForDebug() ;
	}
	

}

// Call JCAT_UIObjectTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_UIObjectTest::main')
	JCAT_UIObjectTest::main();
?>
