<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_CommonSetting.php 2005 2009-08-30 15:10:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_CommonSetting extends JCAT_UIGtkGladeWidgetCompilerBase
{



	/**
	 * 编译
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject )
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIGtkGladeWidget') ;
		
		// 已编译内容
		$sCompiled = "\r\n".$aObject->GetCompiled() ;
		
		// 窗体变量名称
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		
		// 请求尺寸
		$nWidthRequest = ($nWidthRequest=$aObject->GetProperty('width_request'))===null? -1: intval($nWidthRequest) ;
		$nHeightRequest = ($nHeightRequest=$aObject->GetProperty('height_request'))===null? -1: intval($nHeightRequest) ;
		if( $nWidthRequest>=0 or $nHeightRequest>=0 )
			$sCompiled.= "\t\t{$sVariableName}->set_size_request( {$nWidthRequest}, {$nHeightRequest} ) ;\r\n" ;			
		
		// 可见
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('visible')) )
			$sCompiled.= "\t\t{$sVariableName}->set_visible( true, false ) ;\r\n" ;
		
		// 敏感
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('sensitive'))===false )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_sensitive( false ) ;\r\n" ;
		}
			
		// 鼠标悬停提示
		if( $sTooltip = JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('tooltip')) )
		{
			$sComments = ($sComments=JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('tooltip','comments')))===null? '': $sComments ;
			$sCompiled.= "\r\n\t\t\$aTip = new GtkTooltips();\r\n" ;
			$sCompiled.= "\t\t\$aTip->set_tip( {$sVariableName}, \$this->GetSentence(\"{$sTooltip}\"), \$this->GetSentence(\"{$sComments}\") );\r\n\r\n" ;
		}
		
		// 不显示全部
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('no_show_all')) )
			$sCompiled.= "\t\t{$sVariableName}->set_no_show_all( true ) ;\r\n" ;
		
		// 可绘制
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('app_paintable')) )
			$sCompiled.= "\t\t{$sVariableName}->set_app_paintable( true ) ;\r\n" ;
		
		// 事件
		if( $sEvents=JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('events')) ) 
		{
			$sEvents = str_replace('GDK_','Gdk::',$sEvents) ;
			$sCompiled.= "\t\t{$sVariableName}->set_events( {$sEvents} ) ;\r\n" ;
		}
		
		// 扩展事件
		if( $sEvents=JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('extension_events')) ) 
		{
			$sEvents = str_replace('GDK_','Gdk::',$sEvents) ;
			$sCompiled.= "\t\t{$sVariableName}->set_extension_events( {$sEvents} ) ;\r\n" ;
		}
		
		// 保存编译结果
		$aObject->SetCompiled($sCompiled) ;
	}


	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject ){}
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking ){}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( 'CommonSetting', __CLASS__ ) ;
	}


}

?>