<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_Custom.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_Custom extends JCAT_UIGtkGladeWidgetCompilerBase
{


	/**
	 * 编译窗体创建代码
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sWidgetId = $aObject->GetWidgetId() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		
		$aObject->SetWidgetId($sWidgetId) ;
		
		if( preg_match('/^@(View|UICtrl):(.+)$/i',$sWidgetId,$arrRes) )
		{
			$sType = $arrRes[1] ;
			$sName = $arrRes[2] ;
			
			// 引用 子视图
			if( $sType==='View' )
			{
				$sCompiled = "
		// 嵌入 子视图
		\$aSubView = JCAT_View::GetViewByGlobalName('{$sName}') ;
		if( \$aSubView )
		{
			{$sVariableName} = \$aSubView->GetWidget() ;
			if( !{$sVariableName} )
			{
				{$sVariableName} = \$aSubView->Create() ;
			}
		}
		else
		{
			{$sVariableName} = new GtkLabel(JCAT_Language::SentenceEx('!Glade 模版错误：名为“%s”的视图不存在。','JCAT',null,'{$sName}')) ;
		}
" ;
				
			}
			
			// 非 Gtk 原生控件
			else if( $sType==='UICtrl' )
			{
				
				$sCompiled = "
		{$sVariableName} = new GtkHBox() ;
		{$sVariableName}->set_name('{$sName}') ;
" ;
			}
			
			// 意外类型
			else
				JCAT_ASSERT::ASSERT_(0,'!?');
		}
		
		// 根据 Create Function 创建窗体
		else
		{
			
		}
		
		return $sCompiled ;
	}



	/**
	 * 编译子窗体并加入到父窗体
	 * 
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static	
	 * @return	void
	 */
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking )
	{
		// 父/子 窗体变量名
		$sParentVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aParentWidget) ;
		$sChildWidgetVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aChildWidget) ;
		
		// 子窗体名
		$sChildWidgetName = $aChildWidget->GetWidgetId() ;
		
		// 上下左右
		if( ($sLeft=$aPacking->GetProperty('left_attach'))===null )
			$sLeft = '-1' ;
		if( ($sRight=$aPacking->GetProperty('right_attach'))===null )
			$sRight = '-1' ;
		if( ($sTop=$aPacking->GetProperty('top_attach'))===null )
			$sTop = '-1' ;
		if( ($sBottom=$aPacking->GetProperty('bottom_attach'))===null )
			$sBottom = '-1' ;

		$sCompiled = "\r\n\t\t{$sChildWidgetVariableName} = self::GetWidget('{$sChildWidgetName}',&\$arrObjectForSignal) ;\r\n" ;

		if( $sLeft<0 or $sTop<0 )
			$sCompiled.= "\r\n\t\t{$sParentVariableName}->append({$sChildWidgetVariableName}) ;\r\n" ;
		else
			$sCompiled.= "\r\n\t\t{$sParentVariableName}->attach({$sChildWidgetVariableName},{$sLeft},{$sRight},{$sTop},{$sBottom}) ;\r\n" ;

		return $sCompiled ;
	}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>