<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkBox.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkBox extends JCAT_UIGtkGladeWidgetCompilerBase
{

	/**
	 * 编译窗体创建代码
	 *
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		// GtkHBox, GtkVBox ...
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;

		$sHomogeneous = JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('homogeneous'))? 'true': 'false' ;
		$sSpacing = ($aObject->GetProperty('spacing')===null)? '0': $aObject->GetProperty('spacing') ;

		return
"		{$sVariableName} = new {$sWidgetClass}() ;
		{$sVariableName}->set_homogeneous({$sHomogeneous}) ;
		{$sVariableName}->set_spacing({$sSpacing}) ;
" ;
	}



	/**
	 * 编译子窗体并加入到父窗体
	 *
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static
	 * @return	void
	 */
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking )
	{
		$sParentVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aParentWidget) ;
		$sChildWidgetVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aChildWidget) ;
		$sChildWidgetId = $aChildWidget->GetWidgetId() ;

		$sCompiled = "\r\n\t\t{$sChildWidgetVariableName} = \$this->GetWidget('{$sChildWidgetId}',&\$arrObjectForSignal) ;\r\n" ;

		$sExpand = (JCAT_UIGtkGladeObject::NodeTextToValue($aPacking->GetProperty('expand'))===false)? 'false': 'true' ;
		$sFill = (JCAT_UIGtkGladeObject::NodeTextToValue($aPacking->GetProperty('fill'))===false)? 'false': 'true' ;
		$sPadding = ($sPadding=$aPacking->GetProperty('fill'))===null? '0': $sPadding ;
		$sPackFunction = $aPacking->GetProperty('pack_type')==='GTK_PACK_END'? 'pack_end': 'pack_start' ;

		$sCompiled.="\t\t{$sParentVariableName}->{$sPackFunction}( {$sChildWidgetVariableName}, {$sExpand}, {$sFill}, {$sPadding} ) ;\r\n\r\n" ;

		return $sCompiled ;
	}

	/**
	 * 注册到处理器管理器
	 *
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>
