<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkButton.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkButton extends JCAT_UIGtkGladeWidgetCompiler_GtkContainer
{


	/**
	 * 编译窗体创建代码
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		
		$sCompiled = "\t\t{$sVariableName} = new {$sWidgetClass}() ;\r\n" ;
		
		// stock 图标按钮
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('use_stock')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_use_stock(true) ;\r\n" ;
			
			// 图标位置  (留待完成！)
			/*if( $sImagePosition=($aObject->GetProperty('image_position')) )
			{
				$sImagePosition = str_replace('GTK_','Gtk::',$sImagePosition) ;
				$sCompiled.= "\t\t{$sVariableName}->set_use_underline( true ) ;\r\n" ;
			}*/
			
		}
		
		// 普通按钮
		else
		{
			// 使用下划线
			if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('use_underline')) )
				$sCompiled.= "\t\t{$sVariableName}->set_use_underline( true ) ;\r\n" ;
		}
		
		// 标签
		if( $sLabel=$aObject->GetProperty('label') )
			$sCompiled.= "\t\t{$sVariableName}->set_label(\$this->GetSentence('{$sLabel}')) ;\r\n" ;
		
		// 使用下划线
		if( $sRelief=$aObject->GetProperty('relief') )
		{
			$sRelief=str_replace('GTK_','Gtk::',$sRelief) ;
			$sCompiled.= "\t\t{$sVariableName}->set_relief( {$sRelief} ) ;\r\n" ;
		}
		
		// 点击时获得焦点
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('focus_on_click'))===false )
			$sCompiled.= "\t\t{$sVariableName}->set_focus_on_click( false ) ;\r\n" ;
			
		// 按钮内元素（label或图） 排列布局
		$nXAlign = ($nXAlign=$aObject->GetProperty('xalign'))===null? 0.5: floatval($nXAlign) ;
		$nYAlign = ($nYAlign=$aObject->GetProperty('yalign'))===null? 0.5: floatval($nYAlign) ;
		if( $nXAlign!=0.5 or $nYAlign!=0.5 )
			$sCompiled.= "\t\t{$sVariableName}->set_alignment( {$nXAlign}, {$nYAlign} ) ;\r\n" ;
		
		// 回应ID (留待完成！)
		// response_id
		return $sCompiled ;
	}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>