<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkLabel.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkLabel extends JCAT_UIGtkGladeWidgetCompilerBase
{


	/**
	 * 编译窗体创建代码
	 *
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sWidgetId = $aObject->GetWidgetId() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;

		
		$sCompiled = "\t\t{$sVariableName} = new {$sWidgetClass}() ;\r\n" ;

		// 文本内容
		$sLable = str_replace('"','\\"',$aObject->GetProperty('label')) ;
		$sCompiled.= "\r\n\t\t{$sVariableName}->set_label(\$this->GetSentence(\"{$sLable}\")) ;" ;

		// 使用标记语言
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('use_markup')) )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_use_markup(true) ;" ;

		// 使用下划线
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('use_underline')) )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_use_underline(true) ;" ;

		// 对齐
		if( $sJustify=$aObject->GetProperty('justify') )
		{
			$sJustify = str_replace('GTK_','Gtk::',$sJustify) ;
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_justify({$sJustify}) ;" ;
		}

		// 模式
		if( $sPattern=$aObject->GetProperty('pattern') )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_pattern('{$sPattern}') ;" ;

		// 自动换行
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('wrap')) )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_line_wrap(true) ;" ;

		// 可选中
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('selectable')) )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_selectable(true) ;" ;

		// 可记忆窗体
		if( $sMnemonicWidget=$aObject->GetProperty('mnemonic_widget') )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_mnemonic_widget( \$this->GetWidget('{$sMnemonicWidget}',&\$arrObjectForSignal) ;\r\n" ;

		// 省略化
		if( $sEllipsize=$aObject->GetProperty('ellipsize') )
		{
			$sEllipsize = str_replace('PANGO_','Pango::',$sEllipsize) ;
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_ellipsize( {$sEllipsize} ) ;" ;
		}

		// 字符宽度
		if( $sWidthChars=$aObject->GetProperty('width_chars') )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_width_chars( {$sWidthChars} ) ;" ;

		// 单行
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('single_line_mode')) )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_single_line_mode(true) ;" ;

		// 角度
		if( $sAngle=$aObject->GetProperty('angle') )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_angle( {$sAngle}*360 ) ;" ;

		// 最大字符宽
		if( $sMaxWidthChars=$aObject->GetProperty('max_width_chars') )
			$sCompiled.= "\r\n\t\t{$sVariableName}->set_max_width_chars( {$sMaxWidthChars} ) ;" ;

		// x/y Align
		$sXAlign = ($sXAlign=$aObject->GetProperty('xalign'))===null? '0.5': $sXAlign ;
		$sYAlign = ($sYAlign=$aObject->GetProperty('yalign'))===null? '0.5': $sYAlign ;
		$sCompiled.= "\r\n\t\t{$sVariableName}->set_alignment( {$sXAlign}, {$sYAlign} ) ;" ;

		// x/y Padding
		$sXPad = ($sXPad=$aObject->GetProperty('xpad'))===null? '0': $sXPad ;
		$sYPad = ($sYPad=$aObject->GetProperty('ypad'))===null? '0': $sYPad ;
		$sCompiled.= "\r\n\t\t{$sVariableName}->set_padding( {$sXPad}, {$sYPad} ) ;" ;


		return $sCompiled ;
	}



	/**
	 * 编译子窗体并加入到父窗体
	 *
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static
	 * @return	void
	 */
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking )
	{}


	/**
	 * 注册到处理器管理器
	 *
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>
