<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkNotebook.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkNotebook extends JCAT_UIGtkGladeWidgetCompilerBase
{
	
	/**
	 * 编译
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject )
	{
		parent::Compile($aObject) ;
		
		$sCompiled = $aObject->GetCompiled() ; 
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;

		// 设置第一页为当前页
		$sCompiled.= "\t\tif( {$sVariableName}->get_n_pages() )\r\n" ;
		$sCompiled.= "\t\t\t{$sVariableName}->set_current_page(0) ;\r\n" ;
		
		$aObject->SetCompiled($sCompiled) ;
	}
	
	/**
	 * 编译窗体创建代码
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		
		$sCompiled = "\t\t{$sVariableName} = new {$sWidgetClass}() ;\r\n" ;
		
		// 标签位置
		if( $sValue = JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('tab_pos')) )
		{
			$sValue = str_replace('GTK_','Gtk::',$sValue) ;
			$sCompiled.= "\t\t{$sVariableName}->set_tab_pos($sValue) ;\r\n" ;
		}
		
		// 显示标签
		if( ($sValue = ($aObject->GetProperty('show_tabs')))!==null )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_show_tabs($sValue) ;\r\n" ;
		}
		
		// 显示边框
		if( ($sValue = ($aObject->GetProperty('show_border')))!==null )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_show_border($sValue) ;\r\n" ;
		}
		
		// 滚动
		if( ($sValue = ($aObject->GetProperty('scrollable')))!==null )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_scrollable($sValue) ;\r\n" ;
		}
		
		// 弹出菜单
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('enable_popup')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->popup_enable() ;\r\n" ;
		}		
		
		return $sCompiled ;
	}



	/**
	 * 编译子窗体并加入到父窗体
	 * 
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static	
	 * @return	void
	 */
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking )
	{
		// 父/子 窗体变量名
		$sParentVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aParentWidget) ;
		$sChildWidgetVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aChildWidget) ;
		
		// 子窗体名
		$sChildWidgetName = $aChildWidget->GetWidgetId() ;

		// 创建 子窗体（不管它是什么，先创建）
		$sCompiled = "\r\n\t\t{$sChildWidgetVariableName} = self::GetWidget('{$sChildWidgetName}',\$arrObjectForSignal) ;" ;
		
		
		// 页内容窗体(page) 和  页标签窗体(tab)  按顺序出现 ----
		
		// 页内容窗体(page)
		if( $aPacking->GetProperty('type')===null )
		{
			$this->aPageContentWidget = $aChildWidget ;
			$sCompiled.= "\r\n\t\t{$sParentVariableName}->append_page({$sChildWidgetVariableName}) ;" ;
			
			// 菜单标签
			if( ($sValue = ($aPacking->GetProperty('menu_label')))!==null )
			{
				$sValue = str_replace('"','\\"',$sValue) ;
				$sCompiled.= "\r\n\t\t{$sParentVariableName}->set_menu_label({$sChildWidgetVariableName},new GtkLabel(\"{$sValue}\")) ;" ;
			}
		}
		
		// 页标签窗体(tab)
		else if( $aPacking->GetProperty('type')=='tab' )
		{
			
			// 空的内容窗体，创建一个空的  GktLabel，并加入到 GtkNotebook
			if( !$this->aPageContentWidget )
			{
				$sPageContentWidgetVarName = '$wndEmptyLabel' ;
				$sCompiled.= "\r\n\t\t// 创建一个空的  GktLabel，作为 页内容 窗体 加入到 GtkNotebook" ;
				$sCompiled.= "\r\n\t\t{$sPageContentWidgetVarName} = new GtkLabel('') ;" ;
				$sCompiled.= "\r\n\t\t{$sParentVariableName}->append_page({$sPageContentWidgetVarName}) ;" ;
				
			}
			
			else
			{
				$sPageContentWidgetVarName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($this->aPageContentWidget) ;
			}
			
			// 将 标签窗体 加入到  GtkNotebook
			$sCompiled.= "\r\n\t\t{$sParentVariableName}->set_tab_label({$sPageContentWidgetVarName},{$sChildWidgetVariableName}) ;" ;
			
			// 标签窗体的  Parking 方式
			$sExpand = $aPacking->GetProperty('tab_expand') ;
			if( $sExpand===null )
			{
				$sExpand = 'false' ;
			}
			$sFill = $aPacking->GetProperty('tab_fill') ;
			if( $sFill===null )
			{
				$sFill = 'false' ;
			}
			$sPack = JCAT_UIGtkGladeObject::NodeTextToValue($aPacking->GetProperty('tab_pack')) ;
			if( $sPack===null )
			{
				$sPack = 'Gtk::PACK_START' ;
			}
			else
			{
				$sPack = str_replace('GTK_','Gtk::',$sPack) ;
			}
			$sCompiled.= "\r\n\t\t{$sParentVariableName}->set_tab_label_packing({$sPageContentWidgetVarName},{$sExpand},{$sFill},{$sPack}) ;" ;

			// 菜单标签
			if( ($sValue = ($aPacking->GetProperty('menu_label')))!==null )
			{
				$sValue = str_replace('"','\\"',$sValue) ;
				$sCompiled.= "\r\n\t\t{$sParentVariableName}->set_menu_label({$sPageContentWidgetVarName},new GtkLabel(\"{$sValue}\")) ;" ;
			}
			
			$sCompiled.= "\r\n" ;

			
			// 清除
			$this->aPageContentWidget = null ;
		}
		
		//
		else
		{
			JCAT_ASSERT::ASSERT_(0,'what`s this?') ;
		}
		
		return $sCompiled ;
	}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


	
	private $aPageContentWidget = null ;
}

?>