<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkTable.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkTable extends JCAT_UIGtkGladeWidgetCompilerBase
{


	/**
	 * 编译窗体创建代码
	 *
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;

		// 行、列
		$nRows = (int)$aObject->GetProperty('n_rows') ;
		$nColumns = (int)$aObject->GetProperty('n_columns') ;

		// 统一大小
		$sHomogeneous =  JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('homogeneous'))? 'true': 'false' ;

		$sCompiled = "\t\t{$sVariableName} = new {$sWidgetClass}( {$nRows}, {$nColumns}, {$sHomogeneous} ) ;\r\n" ;

		// 间隔
		if( $sRowSpacing=$aObject->GetProperty('row_spacing') )
			$sCompiled.= "\t\t{$sVariableName}->set_row_spacings( {$sRowSpacing} ) ;\r\n" ;
		if( $sClmSpacing=$aObject->GetProperty('column_spacing') )
			$sCompiled.= "\t\t{$sVariableName}->set_col_spacings( {$sClmSpacing} ) ;\r\n" ;


		return $sCompiled ;
	}



	/**
	 * 编译子窗体并加入到父窗体
	 *
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static
	 * @return	void
	 */
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking )
	{
		// 父/子 窗体变量名
		$sParentVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aParentWidget) ;
		$sChildWidgetVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aChildWidget) ;
		$sChildWidgetId = $aChildWidget->GetWidgetId() ;


		// 上下左右 位置
		if( ($sLeftAttach=$aPacking->GetProperty('left_attach'))===null )
			$sLeftAttach = '0' ;
		if( ($sRightAttach=$aPacking->GetProperty('right_attach'))===null )
			$sRightAttach = '1' ;
		if( ($sTopAttach=$aPacking->GetProperty('top_attach'))===null )
			$sTopAttach = '0' ;
		if( ($sBottomAttach=$aPacking->GetProperty('bottom_attach'))===null )
			$sBottomAttach = '1' ;

		// x/y options
		if( ($sXOptions=$aPacking->GetProperty('x_options'))===null )
			$sXOptions = 'GTK_EXPAND | GTK_FILL' ;
		if( $sXOptions==='' )
			$sXOptions = '0' ;
		if( ($sYOptions=$aPacking->GetProperty('y_options'))===null )
			$sYOptions = 'GTK_EXPAND | GTK_FILL' ;
		if( $sYOptions==='' )
			$sYOptions = '0' ;
		$sXOptions = str_replace('GTK_','Gtk::',$sXOptions) ;
		$sYOptions = str_replace('GTK_','Gtk::',$sYOptions) ;

		// x/y padding
		if( ($sXPadding=$aPacking->GetProperty('x_padding'))===null )
			$sXPadding = '0' ;
		if( ($sYPadding=$aPacking->GetProperty('y_padding'))===null )
			$sYPadding = '1' ;

		$sCompiled = "\r\n\t\t{$sChildWidgetVariableName} = \$this->GetWidget('{$sChildWidgetId}',&\$arrObjectForSignal) ;\r\n" ;
		$sCompiled.= "\t\t{$sParentVariableName}->attach({$sChildWidgetVariableName}, {$sLeftAttach},{$sRightAttach},{$sTopAttach},{$sBottomAttach}, {$sXOptions},{$sYOptions}, {$sXPadding},{$sYPadding}) ;\r\n" ;

		return $sCompiled ;
	}


	/**
	 * 注册到处理器管理器
	 *
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>
