<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkTextView.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkTextView extends JCAT_UIGtkGladeWidgetCompilerBase
{


	/**
	 * 编译窗体创建代码
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		
		$sCompiled = "\t\t{$sVariableName} = new {$sWidgetClass}() ;\r\n" ;
		$sCompiled.= "\t\t\$aTextBuffer = new GtkTextBuffer() ;\r\n" ;
		$sCompiled.= "\t\t{$sVariableName}->set_buffer(\$aTextBuffer) ;\r\n" ;
		
		// 行上像素
		if( ($sValue=$aObject->GetProperty('pixels_above_lines'))!==null )
			$sCompiled.= "\t\t{$sVariableName}->set_pixels_above_lines({$sValue});\r\n" ;
		
		// 行下像素
		if( ($sValue=$aObject->GetProperty('pixels_below_lines'))!==null )
			$sCompiled.= "\t\t{$sVariableName}->set_pixels_below_lines({$sValue});\r\n" ;
		
		// 回绕行间距
		if( ($sValue=$aObject->GetProperty('pixels_inside_wrap'))!==null )
			$sCompiled.= "\t\t{$sVariableName}->set_pixels_inside_wrap({$sValue});\r\n" ;	
			
		// 可编辑
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('editable'))===false )
			$sCompiled.= "\t\t{$sVariableName}->set_editable(false) ;\r\n" ;
		
		// 换行模式
		if( ($sValue=$aObject->GetProperty('wrap_mode'))!==null )
		{
			$sValue = str_replace('GTK_','Gtk::',$sValue) ;
			$sCompiled.= "\t\t{$sVariableName}->set_wrap_mode({$sValue});\r\n" ;	
		}
		
		// 对齐
		if( ($sValue=$aObject->GetProperty('justification'))!==null )
		{
			$sValue = str_replace('GTK_','Gtk::',$sValue) ;
			$sCompiled.= "\t\t{$sVariableName}->set_justification({$sValue});\r\n" ;	
		}
		
		// 左边距
		if( ($sValue=$aObject->GetProperty('left_margin'))!==null )
			$sCompiled.= "\t\t{$sVariableName}->set_left_margin({$sValue});\r\n" ;	
		
		// 右边距
		if( ($sValue=$aObject->GetProperty('right_margin'))!==null )
			$sCompiled.= "\t\t{$sVariableName}->set_right_margin({$sValue});\r\n" ;	
		
		// 缩进
		if( ($sValue=$aObject->GetProperty('indent'))!==null )
			$sCompiled.= "\t\t{$sVariableName}->set_indent({$sValue});\r\n" ;	
			
		// 光标可见
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('cursor_visible'))===false )
			$sCompiled.= "\t\t{$sVariableName}->set_cursor_visible(false) ;\r\n" ;
			
		// 覆盖模式
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('overwrite')) )
			$sCompiled.= "\t\t{$sVariableName}->set_overwrite(true) ;\r\n" ;
			
		// 接受跳格
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('accepts_tab'))===false )
			$sCompiled.= "\t\t{$sVariableName}->set_accepts_tab(false) ;\r\n" ;
			
		// 预设文本
		if( $sText=$aObject->GetProperty('text') )
			$sCompiled.= "\t\t\$aTextBuffer->set_text(\$this->GetSentence(\"{$sText}\")) ;\r\n" ;
		
		return $sCompiled ;
	}



	/**
	 * 编译子窗体并加入到父窗体
	 * 
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static	
	 * @return	void
	 */
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking )
	{}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>