<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkTreeView.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkTreeView extends JCAT_UIGtkGladeWidgetCompilerBase
{


	/**
	 * 编译窗体创建代码
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		
		$sCompiled = "\t\t{$sVariableName} = new {$sWidgetClass}() ;\r\n" ;
		
		
		// 列头可见
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('headers_visible'))===false )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_headers_visible(false) ;\r\n" ;
		}
			
		// 列头可点击
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('headers_clickable')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_headers_clickable(true) ;\r\n" ;
		}
			
		// 重新排列
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('reorderable')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_reorderable(true) ;\r\n" ;
		}
			
		// 规则提示
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('rules_hint')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_rules_hint(true) ;\r\n" ;
		}
		
		// 启用搜索
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('enable_search'))===false )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_enable_search(false) ;\r\n" ;
		}
		
		// 搜索列
		if( ($sValue = $aObject->GetProperty('search_column'))!==null )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_search_column({$sValue}) ;\r\n" ;
		}
		
		// 高度固定
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('fixed_height_mode')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_fixed_height_mode(true) ;\r\n" ;
		}
		
		// 旋停选择
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('hover_selection')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_hover_selection(true) ;\r\n" ;
		}
		
		// 旋停固定
		if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('hover_expand')) )
		{
			$sCompiled.= "\t\t{$sVariableName}->set_hover_expand(true) ;\r\n" ;
		}
			
		// show expanders
		//if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('show_expanders'))===false )
		//	$sCompiled.= "\t\t{$sVariableName}->set_show_expanders(false) ;\r\n" ;
			
		// level_indentation
		//if( ($sValue = $aObject->GetProperty('level_indentation'))!==null )
		//	$sCompiled.= "\t\t{$sVariableName}->set_level_indentation({$sValue}) ;\r\n" ;

		// rubber_banding
		//if( JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('rubber_banding')) )
		//	$sCompiled.= "\t\t{$sVariableName}->set_rubber_banding(true) ;\r\n" ;

		// enable_tree_lines
		if( $sValue=JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty('enable_tree_lines')) )
		{
			$sValue = str_replace('GTK_','Gtk::',$sValue) ;
			$sCompiled.= "\t\t{$sVariableName}->set_grid_lines({$sValue}) ;\r\n" ;
		}
			
		
		return $sCompiled ;
	}



	/**
	 * 编译子窗体并加入到父窗体
	 * 
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static	
	 * @return	void
	 */
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking )
	{}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>