<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_GtkWindow.php 1961 2009-08-15 08:24:45Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_GtkWindow extends JCAT_UIGtkGladeWidgetCompiler_GtkContainer
{


	/**
	 * 编译窗体创建代码
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject )
	{
		$sWidgetClass = $aObject->GetWidgetClass() ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		
		// 窗口类型
		if( ($sValue=$aObject->GetProperty('type'))!==null )
			$sValue = str_replace('GTK_','Gtk::',$sValue) ;
		else
			$sValue = '' ;
			
		// 构造函数
		$sCompiled = "\t\t{$sVariableName} = new {$sWidgetClass}({$sValue}) ;\r\n\r\n" ;
		
		// 窗口标题
		$this->_SetStringInt($aObject,$sCompiled,'title') ;
		
		// 窗口角色
		$this->_SetStringInt($aObject,$sCompiled,'role') ;
		
		// 可变大小
		$this->_SetBool($aObject,$sCompiled,'resizable') ;
		
		// 模态
		$this->_SetBool($aObject,$sCompiled,'modal') ;
		
		// 窗口位置
		$this->_SetStringInt($aObject,$sCompiled,'window_position',false,'set_position') ;
		
		// 随主窗口关闭
		$this->_SetBool($aObject,$sCompiled,'destroy_with_parent') ;
		
		// 图标
		$this->_SetStringInt($aObject,$sCompiled,'icon') ;
		
		// 图标名称
		$this->_SetStringInt($aObject,$sCompiled,'icon_name') ;
		
		// 类型提示
		$this->_SetStringInt($aObject,$sCompiled,'type_hint',false) ;
		
		// 跳过任务栏
		$this->_SetBool($aObject,$sCompiled,'skip_taskbar_hint') ;
		
		// 跳过窗口选择器
		$this->_SetBool($aObject,$sCompiled,'skip_pager_hint') ;
		
		// 接受焦点
		$this->_SetBool($aObject,$sCompiled,'accept_focus') ;
		
		// 映射时获得焦点
		$this->_SetBool($aObject,$sCompiled,'focus_on_map') ;
		
		// 装饰
		$this->_SetBool($aObject,$sCompiled,'decorated') ;
		
		// Transient Window
		$this->_SetStringInt($aObject,$sCompiled,'transient_for',false) ;

		// 边框  border_width
		$this->_SetStringInt($aObject,$sCompiled,'border_width',false) ;
			
		
		return $sCompiled ;
	}



	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( str_replace('JCAT_UIGtkGladeWidgetCompiler_','',__CLASS__), __CLASS__ ) ;
	}


}

?>