<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompiler_Signals.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetCompiler_Signals extends JCAT_UIGtkGladeWidgetCompilerBase
{



	/**
	 * 编译
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject )
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIGtkGladeWidget') ;
		
		// 已编译内容
		$sCompiled = "\r\n".$aObject->GetCompiled() ;
		
		// 窗体变量名称
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		$sWidgetId = $aObject->GetWidgetId() ;
		
		$aIterator = $aObject->CreateSignalIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$arrSignal = $aIterator->Current() ;//print_r($arrSignal) ;
			
			$arrSignal['function'] = trim($arrSignal['function']) ;
			
			// 连接方式 ================
			$sConnectFunction = 'connect' ;
			if( preg_match('/^@/',$arrSignal['function']) )
			{
				$arrSignal['function'] = preg_replace('/^@/','',$arrSignal['function']) ;
				$sConnectFunction.= '_simple' ;
			}
			if( preg_match('/^\*/',$arrSignal['function']) )
			{
				$arrSignal['function'] = preg_replace('/^\*/','',$arrSignal['function']) ;
				$sConnectFunction.= '_after' ;
			}
				
			// 回调函数 ================
			$arrHandle = explode('::',$arrSignal['function']) ;
			foreach($arrHandle as &$sItem)
			{
				if( preg_match('/^[\w_]+$/',$sItem) )
				{
					$sItem = "'{$sItem}'" ;
				}
			}
	
			$n = count($arrHandle) ;
			if( $n==1 )
			{
				// JCAT_IEventProcessor 对象 
				if( preg_match('/^\$/',$arrHandle[0]) )
				{
					$sHandle = "array('JCAT_EventProcessor','EventTransmitForGtkSignal')" ;
					$arrSignal['object'].= ($arrSignal['object']?', ':'') . "{$arrSignal['function']}, '{$sWidgetId}-{$arrSignal['name']}'" ;
				}
				
				// 全局函数
				else
				{
					$sHandle = $arrHandle[0] ;
				}
			}
			
			// 类方法
			else if( $n==2 )
			{
				$sHandle = "array({$arrHandle[0]},{$arrHandle[1]})" ;
			}
			
			// !?
			else
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx('意外的 Gtk Signal Handle格式“%s”','JCAT',null,$arrSignal['function']), __macro_exception_code__ ) ;
			}
			
			// 参数 ===================
			if( $arrSignal['object'] )
			{
				$arrSignal['object'] = ','.$arrSignal['object'] ;
			}
			
			
				
			$sCompiled.= "\t\t{$sVariableName}->{$sConnectFunction}( '{$arrSignal['name']}', {$sHandle} {$arrSignal['object']} ) ;\r\n" ;

			$aIterator->Next() ;
		}
		
		// 保存编译结果
		$aObject->SetCompiled($sCompiled) ;
	}


	protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject ){}
	protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking ){}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( 'Signals', __CLASS__ ) ;
	}


}

?>