<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidget.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidget extends JCAT_UIGtkGladeObject
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sClass	string	What's this Parameter ?
	 * @param	$sId	string	What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_UIGtkGladeWidget( $sClass, $sId ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sClass) ;
		JCAT_ASSERT::ASSERT_STRING($sId) ;
		
		JCAT_ASSERT::ASSERT_($sClass,'') ;
		JCAT_ASSERT::ASSERT_($sId,'') ;
		
		$this->JCAT_UIObject('') ;
		
		$this->sClass = $sClass ;
		$this->sId = $sId ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetWidgetClass(  ) 
	{ return $this->sClass ;}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetWidgetId() 
	{ return $this->sId ;}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function SetWidgetId($sId) 
	{ $this->sId = $sId ;}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aWidget	JCAT_UIGtkGladeWidget			What's this Parameter ?
	 * @param	$aPacking	_JCAT_UIGtkGladeWidgetPacking	What's this Parameter ?
	 * @return	void
	 */
	public function AddUIObject( JCAT_UIGtkGladeWidget $aWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking ) 
	{
		$this->arrChildUIObject[] = new _JCAT_UIGtkGladeWidgetChild($aWidget,$aPacking) ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearChildWidget(  ) 
	{
		$nCount = $this->arrChildUIObject ;
		$this->arrChildUIObject = array() ;
		return $nCount ;
	}

	/**
	 * 
	 *
	 * @access	public
	 * @return	void
	 */
	public function AddSignal( $sName, $sFunction, $sObject, $bAfter )
	{
		$this->arrSignals[] = array(
			'name' => $sName,
			'function' => $sFunction,
			'object' => $sObject,
			'after' => $bAfter,
		) ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	void
	 */
	public function CreateSignalIterator()
	{
		return new JCAT_ArrayIterator($this->arrSignals) ;
	}
	
	
	
	/**
	 * 编译
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Compile() 
	{
		// 检查 同名 窗体是否存在
		$aUI = $this->GetTemplate() ;
		$aUI->_CheckSameIDWidget($this->GetWidgetId(),$this->GetWidgetClass()) ;
		
		// 编译自己(窗体基本创建$aUI->代码)
		JCAT_UIObject::Compile() ;
		
		// Glade common 设定
		$aParser = $this->GetParser() ;											JCAT_ASSERT::ASSERT_INSTANCE($aParser,'JCAT_IUIObjectParser') ;
		$aCompilerManager = $aParser->GetCompilerManager() ;					JCAT_ASSERT::ASSERT_INSTANCE($aCompilerManager,'JCAT_UIObjectProcessorManager') ;
		$aCompiler = $aCompilerManager->GetProcessor('CommonSetting') ;			JCAT_ASSERT::ASSERT_INSTANCE($aCompiler,'JCAT_IUIObjectCompiler') ;
		$aCompiler->Compile($this) ;

		// Signals
		$aCompiler = $aCompilerManager->GetProcessor('Signals') ;				JCAT_ASSERT::ASSERT_INSTANCE($aCompiler,'JCAT_IUIObjectCompiler') ;
		$aCompiler->Compile($this) ;

		// 已编译内容
		$sCompiled = (string)$this->GetCompiled() ;

		// 
		$sWidgetClass = $this->GetWidgetClass() ;
		$sWidgetId = $this->GetWidgetId() ;
		$sVariable = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($this) ;

		// 窗体创建函数
		$sFunctionName = JCAT_UIGtkGlade::GetWidgetCreateFunctionName($this) ;
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($this) ;	
		
		$sCompiled = "
	/**
	 * 创建窗体 {$sWidgetClass}:{$sWidgetId}
	 * 
	 * @access	private
	 * @param	\$arrObjectForSignal=array()	array	用于响应 Signal 事件的对象, 数组键名做为 对象的变量名
	 * @return	{$sWidgetClass}
	 */
	protected function {$sFunctionName}(array \$arrObjectForSignal=array())
	{
		JCAT_ASSERT::ASSERT_ISTHESE( \$arrObjectForSignal, array('array:object,null') ) ;

		// 声明 用于响应 Signal 事件的对象的引用
		foreach( \$arrObjectForSignal as \$sObName=>\$aObject )
		{
			if( \$aObject )
				\$\$sObName = \$aObject ;
		}

{$sCompiled}

		// 窗体名称
		if( isset({$sVariableName}) and {$sVariableName}->get_name()=='{$sWidgetClass}' )
		{
			{$sVariableName}->set_name('{$sWidgetId}') ;
		}
		
		// 在 窗体中 记录 Creator
		if( isset({$sVariableName}) and !{$sVariableName}->get_data('creator') )
		{
			{$sVariableName}->set_data('creator',\$this) ;
		}
					
		return {$sVariableName} ;
	}


";

		// 设置 窗体树
		$aUI->_AddWidget($this->GetWidgetClass().':'.$this->GetWidgetId()) ;

		// 编译 子窗体
		$aIterator = $this->CreateUIObjectIterator() ;
		$aIterator->First() ;

		while( !$aIterator->IsDone() )
		{
			$aChildUIObject = $aIterator->Current() ;
			JCAT_ASSERT::ASSERT_INSTANCE($aChildUIObject,'_JCAT_UIGtkGladeWidgetChild') ;
			
			$aChildWidget = $aChildUIObject->GetWidget() ;// print_r($aChildWidget ) ;
			JCAT_ASSERT::ASSERT_INSTANCE($aChildUIObject,__CLASS__) ;
			
			// 设置 窗体树
			$aUI->_AddWidget($aChildUIObject->GetWidgetClass().':'.$aChildUIObject->GetWidgetId(), $this->GetWidgetClass().':'.$this->GetWidgetId()) ;
			
			// 编译子对象
			$aChildWidget->Compile() ;
			
			// 置换 对象
			$sCompiled.= $aChildWidget->GetCompiled() ;
		
			// 迭代至上一个
			$aIterator->Next() ;
		}
		
		$this->SetCompiled($sCompiled) ;
		
	}



	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sClass ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sId ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrSignals = array() ;


}



?>