<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetCompilerBase.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/







/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_UIGtkGladeWidgetCompilerBase extends JCAT_UIObjectCompilerBase implements JCAT_IUIAutoloadableProcessor, JCAT_IUIObjectCompiler
{


	/**
	 * 编译
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	void
	 */
	public function Compile( JCAT_UIObject $aObject )
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIGtkGladeWidget') ;

		// 创建窗体代码
		$sCompiled = $this->_CompileCreateWidget($aObject) ;
		
		// 子窗体
		$aIterator = $aObject->CreateUIObjectIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aChild = $aIterator->Current() ;
			
			$aPacking = $aChild->GetPacking() ;
			$aChildWidget = $aChild->GetWidget() ;
			
			JCAT_ASSERT::ASSERT_INSTANCE($aPacking,'_JCAT_UIGtkGladeWidgetPacking') ;
			JCAT_ASSERT::ASSERT_INSTANCE($aChildWidget,'JCAT_UIGtkGladeWidget') ;
		
			$sCompiled.= $this->_CompileChildWidgetPacking($aObject,$aChildWidget,$aPacking) ;
			
			$aIterator->Next() ;
		}
		
		// 保存编译结果
		$aObject->SetCompiled((string)$sCompiled) ;
	}
	
	
	
	
	/**
	 * 编译窗体创建代码
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	Widget对象
	 * @return	string
	 */
	abstract protected function _CompileCreateWidget( JCAT_UIGtkGladeWidget $aObject ) ;
	
	
	/**
	 * 编译子窗体并加入到父窗体
	 * 
	 * @access	public
	 * @param	$aParentWidget		JCAT_UIGtkGladeWidget			父窗体
	 * @param	$aChildWidget		JCAT_UIGtkGladeWidget			子窗体
	 * @param	$aPacking			_JCAT_UIGtkGladeWidgetPacking	打包方式
	 * @static	
	 * @return	void
	 */
	abstract protected function _CompileChildWidgetPacking( JCAT_UIGtkGladeWidget $aParentWidget,JCAT_UIGtkGladeWidget $aChildWidget, _JCAT_UIGtkGladeWidgetPacking $aPacking ) ;
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$aObject			What's this Parameter ?
	 * @param	$sCompiled			What's this Parameter ?
	 * @param	$sPropertyName		What's this Parameter ?
	 * @param	$bConst				What's this Parameter ?
	 * @param	$sSetMethodName	What's this Parameter ?
	 * @return	void
	 */
	protected function _SetStringInt(JCAT_UIGtkGladeWidget $aObject,&$sCompiled,$sPropertyName,$bString=true,$sSetMethodName=null)
	{
		JCAT_ASSERT::ASSERT_STRING($sCompiled) ;
		
		if($sSetMethodName===null)
			$sSetMethodName = 'set_'.$sPropertyName ;
		JCAT_ASSERT::ASSERT_STRING($sSetMethodName) ;
		
		if( ($sValue=$aObject->GetProperty($sPropertyName))===null )
			return ;
		
		// 常量
		if(!$bString)
		{
			$sValue = str_replace('GTK_','Gtk::',$sValue) ;
			$sValue = str_replace('GDK_','Gdk::',$sValue) ;
			$sValue = str_replace('PANGO_','Pango::',$sValue) ;
		}
		else
		{
			$sValue = "\$this->GetSentence('{$sValue}')" ;
		}
			
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		$sCompiled.= "\t\t{$sVariableName}->{$sSetMethodName}({$sValue}) ;\r\n" ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$aObject			What's this Parameter ?
	 * @param	$sCompiled			What's this Parameter ?
	 * @param	$sPropertyName		What's this Parameter ?
	 * @param	$sSetMethodName	What's this Parameter ?
	 * @return	void
	 */
	protected function _SetBool(JCAT_UIGtkGladeWidget $aObject,&$sCompiled,$sPropertyName,$sSetMethodName=null)
	{
		JCAT_ASSERT::ASSERT_STRING($sCompiled) ;
		
		if($sSetMethodName===null)
			$sSetMethodName = 'set_'.$sPropertyName ;
		JCAT_ASSERT::ASSERT_STRING($sSetMethodName) ;
		
		$bValue=JCAT_UIGtkGladeObject::NodeTextToValue($aObject->GetProperty($sPropertyName)) ;
		if( $bValue===null )
			return ;
		
		$sValue = $bValue? 'true': 'false' ;
		
		$sVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aObject) ;
		$sCompiled.= "\t\t{$sVariableName}->{$sSetMethodName}({$sValue}) ;\r\n" ;
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	What's this Parameter ?
	 * @param	$sName		string					What's this Parameter ?
	 * @param	$sDefault	string					What's this Parameter ?
	 * @return	string
	 */
	protected function _GetProperty(JCAT_UIGtkGladeWidget $aObject,$sName,$sDefault)
	{
		return (($sValue=$aObject->GetProperty($sName))===null)? $sDefault: $sValue ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$aObject	JCAT_UIGtkGladeWidget	What's this Parameter ?
	 * @param	$sName		string					What's this Parameter ?
	 * @param	$sDefault	string					What's this Parameter ?
	 * @return	string
	 */
	protected function _CreateChildWidget(JCAT_UIGtkGladeWidget $aChildWidget)
	{
		$sChildWidgetVariableName = '$'.JCAT_UIGtkGlade::GetWidgetVariableName($aChildWidget) ;
		$sWidgetId = $aChildWidget->GetWidgetId() ;
		
		return "{$sChildWidgetVariableName} = self::GetWidget('{$sWidgetId}',\$arrObjectForSignal) ;" ;
	}
	
	
	
	/**
	 * what's this
	 * 
	 * @access	protected
	 * @param	$sSource	string	源文
	 * @return	string
	 */
	protected function _CompileCallback( $sSource )
	{
		$arrHandle = explode('::',$sSource) ;
		foreach($arrHandle as &$sItem)
		{
			if( preg_match('/^[\w_]+$/',$sItem) )
				$sItem = "'{$sItem}'" ;
		}
		
		$n = count($arrHandle) ;
		// 全局函数
		if( $n==1 )
			$sHandle = $arrHandle[0] ;
		
		// 类方法
		else if( $n==2 )
			$sHandle = "array({$arrHandle[0]},{$arrHandle[1]})" ;
		
		// !?
		else
			throw new JCAT_Exception( JCAT_Language::SentenceEx('意外的 Gtk Signal Handle格式“%s”','JCAT',null,$arrSignal['function']), __macro_exception_code__ ) ;
		
		return $sHandle ;
	}
	
}
?>