<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkGladeWidgetParser.php 1842 2009-05-19 12:25:18Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkGladeWidgetParser extends JCAT_UIObjectParserBase implements JCAT_IUIAutoloadableProcessor
{

	public function JCAT_UIGtkGladeWidgetParser()
	{
		$aCompilerManager = new JCAT_UIObjectProcessorManager() ;
		
		// 自动载入 编译器目录下的 所有 编译器
		foreach(self::$arrCompilerDirs as $sDir)
		{
			$aCompilerManager->AddAutoloadProcessorDir($sDir) ;
		}

		$aCompilerManager->AutoloadProcessor() ;
		$this->SetCompilerManager($aCompilerManager) ;
	}

	/**
	 * 分析模版，找到并创建 UI对象
	 * 
	 * @access	public
	 * @param	$aUITemplate			JCAT_UI		UI模版对象
	 * @param	$sTemplatePath			string		模板文件路径
	 * @param	& $sCompiled			string		in/out 前一分析器的分析结果输入，和此分析器的分析结果输出 
	 * @return	void
	 */
	public function Parse( JCAT_UI $aUITemplate,$sTemplatePath, & $sCompiled )
	{
		JCAT_ASSERT::ASSERT_STRING($sCompiled) ;
		
		$aModel = simplexml_load_string(&$sCompiled) ;
		
		if( $aModel===false )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx('Glade 窗口模版文件存在错误。','JCAT',null), JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
		}
		
		$arrWindows = $aModel->children() ;
		foreach($arrWindows as $aWindowNode)
		{
			$aWindowWidget = $this->_ProcessWidget( $aWindowNode, $aUITemplate ) ;
			$aUITemplate->PutInUIObject($aWindowWidget) ;
		}
		
		//print_R($aUITemplate) ;
	}

	/**
	 * 分析处理一个窗体节点
	 *
	 * @access	public
	 * @param	$aWidgetNode	SimpleXMLElement	What's this Parameter ?
	 * @return	void
	 */
	public function _ProcessWidget( SimpleXMLElement $aWidgetNode, JCAT_UI $aUITemplate )
	{
		$sWidgetClass = strval($aWidgetNode['class']) ;
		$aWidget = new JCAT_UIGtkGladeWidget($sWidgetClass,strval($aWidgetNode['id'])) ;
		
		// 装配UI对象
		$aWidget->SetTemplate($aUITemplate) ;
		$aWidget->SetParser($this) ;
		$aCompiler = $this->QueryCompilerByNodeName($sWidgetClass) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aCompiler,'JCAT_IUIObjectCompiler') ;
		$aWidget->PutInCompiler( $aCompiler ) ;
		// echo $sWidgetClass.':'.get_class($aCompiler)."\r\n" ;
		
		
		// 属性
		$arrPropertyNodes = $aWidgetNode->xpath('property') ;
		foreach($arrPropertyNodes as $aPropertyNode)
		{
			$aProperty = new _JCAT_UIGtkGladeWidgetProperty( strval($aPropertyNode['name']), strval($aPropertyNode) ) ;
			
			// 依次设置 Property 节点的属性
			foreach( $aPropertyNode->attributes as $sName=>$sValue )
			{
				if( strtolower($sName)=='name' )
				{
					continue ;
				}
				$aProperty->Set($sName,$sValue) ;
			}
					
			$aWidget->AddProperty($aProperty) ;
		}
		
		
		// 信号事件
		$arrSignalNodes = $aWidgetNode->xpath('signal') ;
		foreach($arrSignalNodes as $aSignalNode)
		{
			$aWidget->AddSignal(
				$aSignalNode['name'], $aSignalNode['handler'],
				isset($aSignalNode['object'])? $aSignalNode['object']: null, 
				JCAT_UIGtkGladeObject::NodeTextToValue( isset($aSignalNode['after'])? (string)$aSignalNode['after']: 'no' )
			) ;
		}
		
		
		// 下级子窗体
		$arrChildrenNode = $aWidgetNode->xpath('child') ;
		foreach($arrChildrenNode as $aChildNode)
		{
			$arrChildWidget = $aChildNode->xpath('widget') ;
			
			// 空位
			if( !isset($arrChildWidget[0]) )
			{
				continue ;
			}
			
			$aChildWidget = $this->_ProcessWidget($arrChildWidget[0],$aUITemplate) ;
			// print_r($aChildWidget) ;
			
			// 打包方式
			$aPacking = new _JCAT_UIGtkGladeWidgetPacking() ;
			
			// 依次处理 Packing 的  Property
			$arrChildPacking = $aChildNode->xpath('packing') ;
			if( isset($arrChildPacking[0]) )
			{
				$arrPackingPropertys = $arrChildPacking[0]->xpath('property') ;
				foreach($arrPackingPropertys as $aPropertyNode)
				{
					$aProperty = new _JCAT_UIGtkGladeWidgetProperty( strval($aPropertyNode['name']), strval($aPropertyNode) ) ;
					
					// 依次设置 Property 节点的属性
					foreach( $aPropertyNode->attributes as $sName=>$sValue )
					{
						if( strtolower($sName)=='name' )
						{
							continue ;
						}
						$aProperty->Set($sName,$sValue) ;
					}
					
					// 加入到 packing 对象中
					$aPacking->AddProperty($aProperty) ;
				}
			}
			
			$aWidget->AddUIObject($aChildWidget,$aPacking) ;
		}
		
		return $aWidget ;
	}
	
	
	
	/**
	 * 根据节点名称 查询 编译器
	 *
	 * @access	public
	 * @param	$sWidgetClass	string	节点名称
	 * @return	JCAT_IUIObjectCompiler, null 
	 */
	public function QueryCompilerByNodeName( $sWidgetClass )
	{
		JCAT_ASSERT::ASSERT_STRING($sWidgetClass) ;
		$aManager = $this->GetCompilerManager() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aManager,'JCAT_IUIObjectProcessorManager') ;
		
		$sClass = $sWidgetClass ;
		while( $sClass )
		{
			if( $aCompiler=$aManager->GetProcessor($sClass) )
			{
				return $aCompiler ;
			}
			$sClass = get_parent_class($sClass) ;
		}
		
		
		throw new JCAT_Exception( JCAT_Language::SentenceEx('无法为：“%s”类型的窗体(Widget)找到编译器','JCAT',null,$sWidgetClass), JCAT_Exception::MakeExceptionCode(__CLASS__,2) ) ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDir	string	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function AddCompilerDir( $sDir ) 
	{
		JCAT_ASSERT::ASSERT_DIR($sDir) ;

		$sDirPath = JCAT_Global::TidyPath($sDir) ;

		if( !in_array($sDirPath,self::$arrCompilerDirs) )
		{
			self::$arrCompilerDirs[] = $sDirPath ;
		}
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @static
	 * @return	int
	 */
	static public function ClearCompilerDir() 
	{
		$nCount = count(self::$arrCompilerDirs) ;
		self::$arrCompilerDirs = array() ;
		return $nCount ;
	}


	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( 'UI.Gtk.Glade', __CLASS__ ) ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		array
	 * @static
	 */
	static private $arrCompilerDirs = array() ;

}




JCAT_UIGtkGladeWidgetParser::AddCompilerDir( dirname(__FILE__).'/UIGtkGladeWidgetCompiler/' ) ;


/*macro_exception_code:2*/
?>