<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIGtkWidgetCreator.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIGtkWidgetCreator
{

	// 公共方法 ///////////////////////////////////////////////////////////
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aUI	JCAT_UIGtkGlade
	 * @return	void
	 */
	public function JCAT_UIGtkWidgetCreator(JCAT_UIGtkGlade $aUI)
	{
		$this->aUI = $aUI ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_UIGtkGlade
	 */
	public function GetUI()
	{
		return $this->aUI ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetSentence($sSentence)
	{
		return $this->GetUI()->GetSentence($sSentence) ;
	}
	
	/**
	 * 窗体享元对象 访问接口
	 * 
	 * @access	public
	 * @param	$sID							string		窗体 ID
	 * @param	$arrObjectForSignal=array()		array		用于响应 Signal 事件的对象, 数组键名做为 对象的变量名
	 * @return	GtkWidget
	 */
	public function GetWidget($sID,array $arrObjectForSignal=array())
	{
		if( class_exists('JCAT_UIGtkGlade') )
		{
			$sMethod = 'Create_'.JCAT_UIGtkGlade::GetWidgetVariableName($sID) ;
		}
		else
		{
			$sMethod = 'Create_'.str_replace('-','_',$sID) ;
		}

		$sTheID = JCAT_UIGtkGlade::TrimWidgetID($sID) ;
		
		// 创建一个新的窗体
		if( !isset($this->arrWidgets[$sTheID]) )
		{
			$arrCallback = array($this,$sMethod) ;
			if( !is_callable($arrCallback,false) )
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx('Gtk Glade 模版文件“%s”中没有名为“%s”的窗体。','JCAT',null,$this->GetGladePath(),$sID), self::EXCE_ID_NOWIDGET ) ;
			}
			
			$aNewIns = call_user_func_array( $arrCallback, array($arrObjectForSignal) ) ;
			
			$aNewIns->connect_simple('destroy-event',array($this,'OnDestroy'),$sTheID) ;
			
			$this->arrWidgets[$sTheID] = $aNewIns ;
		}
		
		// 返回享元对象
		return $this->arrWidgets[$sTheID] ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sWidgetID
	 * @return	void
	 */
	public function OnDestroy($sWidgetID)
	{
		unset($this->arrWidgets[$sWidgetID]) ;
	}
	
	/**
	 * 窗体成员树型结构 访问接口
	 * 
	 * @access	public
	 * @return	array
	 */
	public function GetWidgetTree()
	{ return $this->arrWidgetTree ; }
	
	/**
	 * 创建 所有 窗体的迭代器
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateWidgetIdIterator()
	{
		return new JCAT_ArrayIterator($this->arrWidgetIds) ;
	}
	
	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetGladePath()
	{
		return $this->sTemplatePath ;
	}
	
	/**
	 * 添加一个 用于 响应 signal 的对象
	 * 
	 * @access	public
	 * @param	$sName		string		名称
	 * @param	$$aObject	object		对象
	 * @return	array
	 */
	public function AddObjectForSignal( $sName, $aObject )
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aObject) ;
		
		$this->arrObjectForSignal[$sName] = $aObject ;
	}
	
	
	
	
	/**
	 * what's this
	 * 
	 * @access	protected
	 * @param	$			what's this
	 * @return	array
	 */
	protected function ConnectSignal( $sAction, $sObName, $sMethod, $bConnectSimple )
	{
		$arrUserParams = func_get_args() ;
		array_shift($arrUserParams) ;			// remove $sAction
		array_shift($arrUserParams) ;			// remove $sObName
		array_shift($arrUserParams) ;			// remove $sMethod
		array_shift($arrUserParams) ;			// remove $bConnectSimple
		
		JCAT_ASSERT::ASSERT_( isset($this->arrObjectForSignal[$sObName]), JCAT_Language::SentenceEx('名为 %s 的对象尚未设置','JCAT',null,$sObName) );
		
		$arrParams = array(
			$sAction ,
			array( $this->arrObjectForSignal[$sObName], $sMethod )
		) ;
		$arrParams = array_merge($arrParams,$arrUserParams) ;
		
		call_user_func_array( array('Gtk',($bConnectSimple?'connect_simple':'connect')), $arrParams ) ;		
	}
	

	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 已创建的 窗体享元对象
	 * 
	 * @access	private
	 * @var		array
	 */
	protected $arrWidgets = array() ;
	
	
	protected $arrWidgetTree = array() ;

	
	protected $arrWidgetIds = array() ;
	
	/**
	 * 用于响应 事件信号 的对象
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrObjectForSignal = array() ;

	
	/**
	 * Glade 模版文件 路径
	 * 
	 * @access	private
	 * @var		array
	 */
	protected $sTemplatePath = '' ;
	
	private $aUI ;
	
	const EXCE_ID_NOWIDGET = 1 ;
}
?>