<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class._JCAT_UIGtkGladeWidgetProperty.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		private
 */
class _JCAT_UIGtkGladeWidgetProperty
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	void
	 */
	public function _JCAT_UIGtkGladeWidgetProperty( $sName, $sValue ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		JCAT_ASSERT::ASSERT_STRING($sValue) ;
		
		$this->sName = $sName ;
		$this->sValue = $sValue ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetName(  ) 
	{
		return $this->sName ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetValue(  ) 
	{
		return $this->sValue ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sWhat	string	What's this Parameter ?
	 * @param	$sValue	string	What's this Parameter ?
	 * @return	
	 */
	public function Set( $sWhat, $sValue ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sWhat) ;
		JCAT_ASSERT::ASSERT_STRING($sValue) ;
	
		$old_value = isset($this->arrAttributes[$sWhat])? $this->arrAttributes[$sWhat]: null ;
		$this->arrAttributes[$sWhat] = $sValue ;
		return $old_value ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sWhat	string	What's this Parameter ?
	 * @return	
	 */
	public function Get( $sWhat ) 
	{
		return isset($this->arrAttributes[$sWhat])? $this->arrAttributes[$sWhat]: null ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sName ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sValue ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrAttributes = array() ;


}
?>