<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlNodeCompiler_ui_subtemplate_declare.php 1785 2009-05-05 15:47:16Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlNodeCompiler_ui_subtemplate_declare extends JCAT_UIHtmlNodeCompilerBase
{
	public function JCAT_UIHtmlNodeCompiler_ui_subtemplate_declare()
	{
		$this->JCAT_UIHtmlNodeCompilerBase() ;
		$this->arrNotNullAttributes[] = 'name' ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sNodeName		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function QueryCanbeSingleTag(  $sNodeName ) 
	{
		return false ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIObject	What's this Parameter ?
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject ) 
	{
		// 检查参数
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIHtmlNode') ;
		$this->VerifyNode($aObject) ;
		
		// 注册
		self::RegisterSubtemplate($aObject) ;
		
		
		// get subtemplate name and template path
		$aAttribute = $aObject->GetAttribute() ;
		$sSubtemplateName = $aAttribute->GetAttribute('name') ;
		$aTemplate = $aObject->GetTemplate() ;
		$sTemplateCompiledPath = $aTemplate->GetCompiledPath($aObject->GetTemplateFile()) ;
		
		// save subtemplate compiled file
		$sSubtemplateCompiledPath = self::GetSubtemplateCompiledPath($sTemplateCompiledPath,$sSubtemplateName) ;
		$sFunctionName = self::GetSubtemplateFunctionName(basename($aObject->GetTemplateFile()),$sSubtemplateName) ;
		
		$aBody = $aObject->GetBody() ;
		$sSource = $aBody->GetSource() ;
		
		$sParamArrayName = '$__UISubtemplateParamsArrayName' ;
		$sSource = '<'."? function {$sFunctionName}({$sParamArrayName}=array()){
extract({$sParamArrayName},EXTR_OVERWRITE) ;
?"."> {$sSource} <".'? } ?'.'>' ;
		
		
		$aUI = new JCAT_UIHtml() ;
		$aUI->Compiling($sSource,$aObject->GetTemplateFile()) ;
		file_put_contents($sSubtemplateCompiledPath,$sSource) ;

		// 保存并返回
		$aObject->SetCompiled('') ;		
		return '' ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aGlobalManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aGlobalManager ) 
	{
		// Node Name 上级名称空间 的 编译器
		$aParentManager = JCAT_Singleton::GetGlobalInstance('JCAT_UIHtmlNodeCompiler_ui_subtemplate')->GetCompilerManager() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aParentManager,'JCAT_IUIObjectProcessorManager') ;
		
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aParentManager->RegisterProcessor( 'declare', __CLASS__ ) ;
	}



	/**
	 * 
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function GetSubtemplateCompiledPath($sTemplateCompiledPath,$sSubtemplateName)
	{
		// get template compiled path
		$sTemplateCompiledFilename = basename($sTemplateCompiledPath) ;
		$sTemplateCompiledFolder = dirname($sTemplateCompiledPath).'/' ;
		
		return "{$sTemplateCompiledFolder}Subtemplate.{$sSubtemplateName}_{$sTemplateCompiledFilename}" ;
	}
	
	static public function GetSubtemplateFunctionName($sTemplateName,$sSubtemplateName)
	{
		return 'JCATUIHtmlSubtemplate_'.md5($sTemplateName).'_'.md5($sSubtemplateName) ;
	}


	/**
	 * 
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static private function RegisterSubtemplate(JCAT_UIObject $aObject)
	{
		$aAttribute = $aObject->GetAttribute() ;
		$sSubtemplateName = $aAttribute->GetAttribute('name') ;
		$sTemplateFilename = basename($aObject->GetTemplateFile()) ;
		
		if( $aOtherObject=self::GetSubtemplate($sTemplateFilename,$sSubtemplateName) )
		{
			throw $aObject->CreateException(JCAT_Language::SentenceEx(
						'无法在同一个模板文件(%s)上重复定义同名的子模版：%s; 已经在文件%s 第 %s 行处定义。'
						, 'JCAT', null
						, $sTemplateFilename, $sSubtemplateName
						, $aOtherObject->GetTemplateFile()
						, $aOtherObject->GetStartLine()
						
			)) ;
		}
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_UIObject
	 */
	public function GetSubtemplate($sTemplateFilename,$sSubtemplateName)
	{
		return isset(self::$arrSubtemplates[$sTemplateFilename][$sSubtemplateName]) ?
						self::$arrSubtemplates[$sTemplateFilename][$sSubtemplateName] : null ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	
	/**
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrSubtemplates = array() ;

}
?>