<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlNodeCompiler_ui_switch_case.php 1756 2009-04-28 09:06:59Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlNodeCompiler_ui_switch_case extends JCAT_UIHtmlNodeCompilerBase
{

	public function JCAT_UIHtmlNodeCompiler_ui_switch_case()
	{
		$this->JCAT_UIHtmlNodeCompilerBase() ;
	
		$this->arrNotNullAttributes[] = 'default0' ;
	}
	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sNodeName		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function QueryCanbeSingleTag(  $sNodeName ) 
	{
		return false ;
	}



	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aAttribute		JCAT_UIHtmlNodeAttribute
	 * @return	void
	 */
	public function SetExpressionAttributes(JCAT_UIHtmlNodeAttribute $aAttribute)
	{
		$aAttribute->AddExpressionAttribute('default0');
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aObject	JCAT_UIObject	What's this Parameter ?
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aObject ) 
	{
		// 检查参数
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_UIHtmlNode') ;
		$this->VerifyNode($aObject) ;
		
		// 节点属性
		$aAttribute = $aObject->GetAttribute() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aAttribute,'JCAT_UIHtmlNodeAttribute') ;
		
		// 各项属性
		$sExpress = $aAttribute->GetAttribute('default0') ;
		if( strtolower($sExpress)=='default' )
		{
			$sExpress = 'default :' ;
		}
		else 
		{
			$sExpress = 'case '.$sExpress.' :' ;
		}
		
		$sBreak = $aAttribute->GetAttribute('break') ;
		if( !$sBreak )
		{
			$sBreak = 'true' ;
		}
		$sBreak = in_array(strtolower($sBreak),array('no','false','0','off'))? '': 'break ;' ;

		// 执行体
		$aBody = $aObject->GetBody() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aBody,'JCAT_UIHtmlObject') ;
		$sBody = $aBody->GetCompiled() ;
		
		
		$sWrapStartMark = JCAT_UIHtmlNodeCompiler_Wrapper::GetWrapMark($aObject) ;
		$sWrapEndMark = JCAT_UIHtmlNodeCompiler_Wrapper::GetWrapMark($aObject,false) ;
		
		// 编译
		$sCompiled = "<? {$sExpress} ?>{$sWrapStartMark}{$sBody}{$sWrapEndMark}<? {$sBreak} ?>" ;

		// 保存并返回
		$aObject->SetCompiled($sCompiled) ;
		
		
		// 后续处理
		$aWrapperCompiler = JCAT_Singleton::GetGlobalInstance('JCAT_UIHtmlNodeCompiler_Wrapper') ;
		$aObject->PutInCompiler($aWrapperCompiler) ;
		
		
		return $sCompiled ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aGlobalManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aGlobalManager ) 
	{		
		// Node Name 上级名称空间 的 编译器
		$aParentManager = JCAT_Singleton::GetGlobalInstance('JCAT_UIHtmlNodeCompiler_ui_switch')->GetCompilerManager() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aParentManager,'JCAT_IUIObjectProcessorManager') ;
		
		
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aGlobalManager->RegisterProcessor( 'case', __CLASS__ ) ;
		$aParentManager->RegisterProcessor( 'case', __CLASS__ ) ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////

}
?>