<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlNodeAttributeParser.php 1884 2009-05-30 10:38:36Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlNodeAttributeParser extends JCAT_UIHtmlNodeCompilerBase
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sNodeName		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function QueryCanbeSingleTag(  $sNodeName ) 
	{ return false ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aAttribute	JCAT_UIHtmlNodeAttribute	What's this Parameter ?
	 * @return	string
	 */
	public function Compile( JCAT_UIObject $aAttribute ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aAttribute,'JCAT_UIHtmlNodeAttribute') ;
		
		$sAttributeSource = trim( $aAttribute->GetCompiled() ) ;
		self::EscapeCharacterForAttribute($sAttributeSource) ;
		
		
		$arrRegexp[] = "/(([^=\s]+)=)?\"([^\"]+)\"/" ;		// xxx="yyy" 或 "yyy" 格式
		$arrRegexp[] = "/(([^=\s]+)=)?'([^\']+)'/" ;		// xxx='yyy' 或 'yyy' 格式
		$arrRegexp[] = "/(([^=\s]+)=)?([^\s]+)/" ;			// xxx=yyy 或 yyy 格式
		
		$nNameIdx = 2 ;
		$nValueIdx = 3 ;
		
		$nDefaultIdx = 0 ;
		
		foreach($arrRegexp as $sRegexp)
		{
			if( preg_match_all($sRegexp,$sAttributeSource,$arrRes) )
			{
				foreach($arrRes[0] as $nIdx=>$sAttribute)
				{
					$sName = $arrRes[$nNameIdx][$nIdx] ;
					$sValue = &$arrRes[$nValueIdx][$nIdx] ;
					
					if( empty($sName) )
					{
						$sName = 'default'.$nDefaultIdx++ ;
					}
					
					self::EscapeCharacterForAttribute($sValue,false) ;
					//$sName = strtolower($sName) ;
					
					$aAttribute->SetAttribute(&$sName,&$sValue) ;
					$sAttributeSource = str_replace($sAttribute,'',$sAttributeSource) ;
				}
			}
		}

		// 编译表达试
		$aIterator = $aAttribute->CreateAttributeIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$sAttributeName = $aIterator->CurrentKey() ;
			
			if( $aAttribute->IsExpressionAttribute($sAttributeName) )
			{
				$sAttributeValue = $aAttribute->GetAttribute($sAttributeName) ;
			
				$sAttributeValue = self::CompileExpressionAttribute($sAttributeValue) ;
				
				$aAttribute->SetAttribute($sAttributeName,$sAttributeValue) ;
			}
		}
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sTxt	string	What's this Parameter ?
	 * @return	void
	 */
	static public function EscapeCharacterForAttribute( & $sTxt, $bEsc=true )
	{
		JCAT_ASSERT::ASSERT_STRING($sTxt) ;
		JCAT_ASSERT::ASSERT_BOOL($bEsc) ;
		
		// 转义
		if($bEsc)
		{
			$sTxt = str_replace('\\\\','\\',$sTxt) ;				// 转义 \
			$sTxt = str_replace("\\'",'~~{#!`!#}~~',$sTxt) ;		// 转义 '
			$sTxt = str_replace('\\"','~~{#!``!#}~~',$sTxt) ;		// 转义 "
			$sTxt = str_replace('\\$','~~{#!S!#}~~',$sTxt) ;		// 转义 $
			$sTxt = str_replace('\\.','~~{#!dot!#}~~',$sTxt) ;		// 转义 .
		}
		
		// 还原
		else
		{
			// 成员访问符 '->' 符号与  节点的边界符号('<>')冲突，以 . 替代 属性中 出现的 ->
			$sTxt = str_replace('[greater]','>',$sTxt) ;
			$sTxt = str_replace('[less]','<',$sTxt) ;
			
			$sTxt = str_replace("~~{#!`!#}~~","'",$sTxt) ;			// 还原 '
			$sTxt = str_replace('~~{#!``!#}~~','"',$sTxt) ;			// 还原 "
			$sTxt = str_replace('~~{#!S!#}~~','$',$sTxt) ;			// 还原 $
			$sTxt = str_replace('~~{#!dot!#}~~','.',$sTxt) ;			// 还原 .
		}
		
		return $sTxt ;
	}
		
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sAttributeContent
	 * @static
	 * @return	string
	 */
	static public function CompileExpressionAttribute($sAttributeContent)
	{
		// . 转换成 ->
		return str_replace('.','->',$sAttributeContent) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aGlobalManager ) 
	{
	}



	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>