<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlNodeCompilerBase.php 1756 2009-04-28 09:06:59Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/









/**
 * UI.Html.Node 对象 编译器 的基类
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_UIHtmlNodeCompilerBase 	extends		JCAT_UIObjectCompilerBase
											implements	JCAT_IUIAutoloadableProcessor, JCAT_IUIHtmlNodeCompiler
{

	/**
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_UIHtmlNodeCompilerBase()
	{
		/*$aCaller = JCAT_Backtrace::GetCaller() ;
		echo $aCaller->GetFunction() ;
		if( strtolower($aCaller->GetFunction())!='getglobalinstance' )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx(__CLASS__.'只能由 单件方式(JCAT_Singleton) 创建','JCAT',null), __macro_exception_code__ ) ;
		}*/

		$this->aCompilerManager = new JCAT_UIObjectProcessorManager() ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aAttribute		JCAT_UIHtmlNodeAttribute
	 * @return	void
	 */
	public function SetExpressionAttributes(JCAT_UIHtmlNodeAttribute $aAttribute)
	{}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aNode	JCAT_UIHtmlNode	What's this Parameter ?
	 * @return	bool
	 */
	public function VerifyNode( JCAT_UIHtmlNode $aNode )
	{
		$aAttribute = $aNode->GetAttribute() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aAttribute,'JCAT_UIHtmlNodeAttribute') ;
		
		foreach($this->arrNotNullAttributes as $sAttributeName)
		{
			$sAttributeName = strtolower($sAttributeName) ;
			if( $aAttribute->GetAttribute($sAttributeName)===null )
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx('UI节点“%s”缺少必须的属性：“%s”','JCAT',null,$aNode->GetNodeName(),$sAttributeName), __macro_exception_code__ ) ;
			}
		}
		
		return true ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	What's this Parameter ?
	 * @return	old_value
	 */
	public function SetCompilerManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		$old_value = $this->aCompilerManager ;
		$this->aCompilerManager = $aManager ;
		return $old_value ;
	}



	/**
	 * 取得编译器管理器
	 * 
	 * @access	public
	 * @return	JCAT_IUIObjectProcessorManager
	 */
	public function GetCompilerManager()
	{
		return $this->aCompilerManager ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_IUIObjectProcessorManager
	 */
	public function CreateCompilerManagerMemento()
	{
		return clone $this->aCompilerManager ;
	}
	
	

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		JCAT_IUIObjectProcessorManager
	 */
	private $aCompilerManager ;


	protected $arrNotNullAttributes = array() ;

}



?>