<?

class JCAT_CSS
	extends JCAT_HTMLResourceBase
{
	/**
	 *
	 * @access	public
	 * @param	$sUrl	string
	 * @param 	$nType	int
	 * @return	string
	 */
	public function JCAT_CSS($sUrl,$nType=self::LINK)
	{
		if( !is_file($sUrl) and self::$aResourceDirectoryMananger )
		{
			$sUrlFullPath = self::$aResourceDirectoryMananger->GetResource($sUrl) ;
			
			if(!$sUrlFullPath)
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'无法找到 CSS 资源：%s'
					, 'JCAT', null, ($sUrl?$sUrl:'null')
				)) ;
			}
		}
		else
		{
			$sUrlFullPath = $sUrl ;
		}
		
		
		
		$this->JCAT_HTMLResourceBase($sUrlFullPath?$sUrlFullPath:'') ;
		$this->nType = $nType ;
	}
	
	/**
	 * 编译 HTML 引用代码
	 *
	 * @access	public
	 * @return	string
	 */
	public function MakeHTMLAccessCode()
	{
		if($this->nType==self::LINK)
		{
			return '<link href="'.$this->GetAccessUrl().'" type="text/css" rel="stylesheet" />' ;
		}
		
		else if($this->nType==self::IMPORT)
		{
			return '<style>@import url('.$this->GetAccessUrl().') ;</style>' ;
		}
		
		else
		{
			JCAT_ASSERT::ASSERT_(0,'!?')  ;
		}
	}
	
	/**
	 * 添加 CSS 目录
	 *
	 * @access	public
	 * @param	$sDirPath		string
	 * @static 
	 * @return	void
	 */
	static public function AddResourceDirectory($sDirPath)
	{
		if( self::$aResourceDirectoryMananger===null )
		{
			self::$aResourceDirectoryMananger = new JCAT_ResourceDirectoryManager() ;
		}
		
		self::$aResourceDirectoryMananger->AddDirectory($sDirPath) ;
	}
		
	
	const LINK = 1 ;
	const IMPORT = 2 ;
	
	/**
	 * 引用方式
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nType = self::IMPORT ; 
	
	static private $aResourceDirectoryMananger ;
}

?>