<?

abstract class JCAT_HTMLResourceBase
	implements JCAT_IHTMLResource
{
	/**
	 * 编译 HTML 节点属性字串
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function MakeHTMLNodeAttributeStream()
	{
		$arrAttributes = array() ;
		foreach($this->arrHTMLNodeAttributes as $sAttrName=>$sAttrValue)
		{
			$arrAttributes[] = "{$sAttrName}=\"{$sAttrValue}\"" ;
		}
		
		return implode(' ',$arrAttributes) ;
	}
	
	/**
	 *
	 * @access	public
	 * @param	$sUrl	string
	 * @return	void
	 */
	public function JCAT_HTMLResourceBase($sUrl)
	{
		JCAT_ASSERT::ASSERT_STRING($sUrl)  ;
		$this->sUrl = $sUrl ;
	}
	
	/**
	 * 取得对象的URL
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetUrl()
	{
		return $this->sUrl ;
	}
	
	/**
	 * 取得访问对象的URL
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetAccessUrl()
	{
		if( $this->IsLocal() )
		{
			return JCAT_DownloadFile::GetHTTPAccessPath($this->GetUrl()) ;
		}
		
		else 
		{
			return $this->GetUrl() ;
		}
	}
	
	/**
	 * 是否为本地资源
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsLocal()
	{
		return !strstr($this->GetUrl(),'://') ;
	}
	
	/**
	 * pack same files to one file
	 *
	 * @access	public
	 * @param	$sFileList
	 * @param	$sPackagePath
	 * @static
	 * @return	void
	 */
	static public function Package($sFileList,$sPackagePath)
	{
		JCAT_ASSERT::ASSERT_( !is_dir($sPackagePath), JCAT_Language::SentenceEx('无法创建文件：%s; 该路径是一个已经存在的目录。','JCAT',null,$sPackagePath) );
		
		if(is_file($sFileList))
		{
			// the package file is exists, and modify later than file list file, not have to repack
			if( is_file($sPackagePath) and filemtime($sFileList) <= filemtime($sPackagePath) )
			{
				return ;
			}
			
			$sBasePath = dirname($sFileList).'/' ;
			$sFiles = file_get_contents($sFileList) ;
		}
		
		else
		{
			$sBasePath = null ;
			$sFiles = $sFileList ;
		}
		
		$sFiles = JCAT_String::ConvertNewlineStyle($sFiles,JCAT_String::NL_LINUX) ;
		$arrFiles = explode("\n",$sFiles) ;
		
		// 打包
		$hPackage = fopen($sPackagePath,'w') ;
		if( !$hPackage )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法打开并写入文件：%s'
				, 'JCAT', null
				, $sPackagePath
			)) ;
		}
		chmod($sPackagePath,0666) ;
		foreach($arrFiles as $sFileName)
		{
			$sFileName = trim($sFileName) ;
			if(!$sFileName)
			{
				continue ;
			}
			
			if( JCAT_FSO::IsAbsolutePath($sFileName) )
			{
				$sFilePath = $sFileName ;
			}
			else
			{
				if( $sBasePath===null )
				{
					throw new JCAT_Exception(JCAT_Language::SentenceEx(
						'参数 $sFileList 中有一个文件使用了相对路径，由于$sFileList 不是一个清单文件的路径，因为无法定位该相对路径：%s'
						, 'JCAT', null
						, $sFileName
					)) ;
				}
				
				$sFilePath = $sBasePath.$sFileName ;
			}
			
			if( !is_file($sFilePath) )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'文件不存在：%s'
					, 'JCAT', null
					, $sFilePath
				)) ;
			}

			fwrite($hPackage,
				JCAT_Language::SentenceEx("\r\n// 文件: %s \r\n"
					,'JCAT',null,$sFileName)
			) ;
			fwrite($hPackage,"// ----------------------------------------------------------------------------------------\r\n") ;
			fwrite($hPackage,file_get_contents($sFilePath)) ;
			fwrite($hPackage,str_repeat("\r\n",4)) ;
		}
		
		fclose($hPackage) ;
	}
	
	/**
	 * 资源的 Url
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sUrl = '' ;
	
	/**
	 * HTML 节点属性值
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrHTMLNodeAttributes = array() ;
}

?>