<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_HtmlResourceManager
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function HasExists(JCAT_IHTMLResource $aResource)
	{
		return (array_search($aResource,$this->arrResources)!==false) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function HaveOutputed(JCAT_IHTMLResource $aResource)
	{
		return array_search($aResource,$this->arrResourcesOutputed)!==false ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aResource		JCAT_IHTMLResource
	 * @return	void
	 */
	public function AddResource(JCAT_IHTMLResource $aResource)
	{
		if( array_search($aResource,$this->arrResources)!==false )
		{
			return ;
		}
		
		//$nIdx = self::$nRCIndex++ ;
		$this->arrResources[] = $aResource ;
		$this->arrResourcesNotOutput[] = $aResource ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$bOnlyNotOutput=true		bool		只包括尚未输出的资源
	 * @return	JCAT_IIterator
	 */
	public function CreateResourceIterator($bOnlyNotOutput=true)
	{
		return new JCAT_ArrayIterator(
				($bOnlyNotOutput? $this->arrResourcesNotOutput: $this->arrResources)
		) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function SetOutputed(JCAT_IHTMLResource $aResource)
	{
		$nIdx = array_search($aResource,$this->arrResourcesNotOutput) ;
		if($nIdx!==false)
		{
			unset($this->arrResourcesNotOutput[$nIdx]) ;
			$this->arrResourcesOutputed[] = $aResource ;
		}
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		int
	 */
	// static private $nRCIndex = 0 ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrResources = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrResourcesNotOutput = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrResourcesOutputed = array() ;
}

?>