<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlCodeSimpleParser.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * UI.Html.Code 分析器
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlCodeSimpleParser extends JCAT_UIHtmlCodeParser
{

	public function JCAT_UIHtmlCodeSimpleParser()
	{
		$aCompilerManager = new JCAT_UIObjectProcessorManager() ;
		
		// 自动载入 编译器目录下的 所有 编译器
		foreach(self::$arrCompilerDirs as $sDir)
		{
			$aCompilerManager->AddAutoloadProcessorDir($sDir) ;
		}

		$this->SetCompilerManager($aCompilerManager) ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDir	string	What's this Parameter ?
	 * @static
	 * @return	void
	 */
	static public function AddCompilerDir( $sDir ) 
	{
		JCAT_ASSERT::ASSERT_DIR($sDir) ;

		$sDirPath = JCAT_Global::TidyPath($sDir) ;

		if( !in_array($sDirPath,self::$arrCompilerDirs) )
		{
			self::$arrCompilerDirs[] = $sDirPath ;
		}
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @static
	 * @return	int
	 */
	static public function ClearCompilerDir() 
	{
		$nCount = count(self::$arrCompilerDirs) ;
		self::$arrCompilerDirs = array() ;
		return $nCount ;
	}



	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( 'UI.Html.Code.Simple', __CLASS__ ) ;		
	}

	/**
	 * 返回 用于分析对象 的 正则表达式
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function GetRegexpForParsingUIObject(array $arrCompilerNames)
	{
		$sNames = implode('|',$arrCompilerNames) ;
		return "/\{({$sNames})(.+?)\}/s" ;
	}

	
	
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 编译器 目录
	 * 
	 * @access	private
	 * @var		array
	 * @static
	 */
	static private $arrCompilerDirs = array() ;


}

JCAT_UIHtmlCodeSimpleParser::AddCompilerDir( dirname(__FILE__).'/../Compiler/CodeSimpleCompiler/' ) ;



?>