<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlRevertParser.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * UI.Html.Code 分析器
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlRevertParser extends JCAT_UIObjectParserBase implements JCAT_IUIAutoloadableProcessor
{

	public function JCAT_UIHtmlRevertParser()
	{
		/*$aCompilerManager = new JCAT_UIObjectProcessorManager() ;
		$aCompilerManager->RegisterProcessor('Only','JCAT_UIHtmlRevertCompiler') ;
		$this->SetCompilerManager($aCompilerManager) ;*/
	}

	/**
	 * 注册到处理器管理器
	 * 
	 * @access	public
	 * @param	$aManager	JCAT_IUIObjectProcessorManager	处理器管理器
	 * @static
	 * @return	void
	 */
	static public function RegistorToProcessorManager( JCAT_IUIObjectProcessorManager $aManager )
	{
		// 仅仅将类名注册到 处理器管理器中， 将创建实例 延迟到 使用时
		$aManager->RegisterProcessor( 'UI.Revert', __CLASS__ ) ;		
	}
	
	/**
	 * 将内容编码
	 *
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function Encode($sContent)
	{
		$nRand = rand(0,99999999) ;
		return "__##JCAT_UIHtmlRevertParser##START##{$nRand}:".base64_encode($sContent).'##END##JCAT_UIHtmlRevertParser##__' ;
	}

	/**
	 * 分析模版，找到并创建 UI对象
	 * 
	 * @access	public
	 * @param	$aUITemplate			JCAT_UI		UI模版对象
	 * @param	$sTemplatePath			string		模板文件路径
	 * @param	& $sCompiled			string		in/out 前一分析器的分析结果输入，和此分析器的分析结果输出 
	 * @return	void
	 */
	public function Parse( JCAT_UI $aUITemplate,$sTemplatePath, & $sCompiled )
	{
		JCAT_ASSERT::ASSERT_STRING($sCompiled) ;
		$aCompiler = JCAT_UIHtmlRevertCompiler::GetGlobalInstance() ;
		
		// 分析 ... 
		$arrRes = array() ;
		if( preg_match_all( '/__##JCAT_UIHtmlRevertParser##START##\d+:(.+?)##END##JCAT_UIHtmlRevertParser##__/', $sCompiled, $arrRes ) )
		{				
			$nStartFindPos = 0 ;
			
			foreach($arrRes[1] as $nIndex=>$sEncode)
			{
				$sSource = $arrRes[0][$nIndex] ;
				
				// 创建对象
				$aUIObject = new JCAT_UIHtmlObject($sSource) ;
				$aUIObject->SetCompiled($sEncode) ;
				
				// 定位
				$aUIObject->Locate( $sCompiled, $nStartFindPos ) ;
				$aUIObject->SetTemplateFile($sTemplatePath) ;
				$nStartFindPos = $aUIObject->GetEndByte() + 1 ;

				// 进一步装配 UI对象...
				$aUIObject->SetTemplate($aUITemplate) ;		// 所属模版
				$aUIObject->SetParser($this) ;					// 分析器
				$aUIObject->PutInCompiler($aCompiler) ;			// 编译器				
				
				// 将UI对象加入到 对象树中
				$aUITemplate->PutInUIObject($aUIObject) ;
			}
		}
	}

}

?>