<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlNodeAttribute.php 1758 2009-04-28 10:11:18Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlNodeAttribute extends JCAT_UIHtmlObject
{
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sName		string		What's this Parameter ?
	 * @param	$sValue		string		What's this Parameter ?
	 * @return	old_value
	 */
	public function SetAttribute($sName,$sValue)
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		JCAT_ASSERT::ASSERT_STRING($sValue) ;
		
		$sOriginName = $sName ;
		$sName = strtolower($sName) ;
		
		// 属性名 原文
		$this->arrAttributeOriginNames[$sName] = $sOriginName ;
		
		// 属性名/属性值 对
		$old_value = isset($this->arrAttributes[$sName])? $this->arrAttributes[$sName]: null ;
		$this->arrAttributes[$sName] = $sValue ;
		return $old_value ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sName		string		What's this Parameter ?
	 * @return	string
	 */
	public function GetAttribute( $sName )
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		return isset($this->arrAttributes[$sName])?
				$this->arrAttributes[$sName]: 
				null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sName		string		What's this Parameter ?
	 * @return	void
	 */
	public function RemoveAttribute($sName)
	{
		unset($this->arrAttributes[$sName]) ;
		unset($this->arrAttributeOriginNames[$sName]) ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function GetAttributeIterator()
	{
		return $this->CreateAttributeIterator() ;
	}
	
	/**
	 * 创建各属性迭代器
	 *
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateAttributeIterator()
	{
		return new JCAT_ArrayIterator($this->arrAttributes) ;
	}

	/**
	 * 取得属性名称的原文
	 *
	 * @access	public
	 * @param	$sAttrName			string
	 * @return	string
	 */
	public function GetAttributeOriginName($sAttrName)
	{
		return isset($this->arrAttributeOriginNames[$sAttrName])?
					$this->arrAttributeOriginNames[$sAttrName]: null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sAttrName
	 * @return	void
	 */
	public function AddExpressionAttribute($sAttrName)
	{
		$sLowerAttrName = strtolower($sAttrName) ;
		if( !in_array($sLowerAttrName,$this->arrExpressionAttrs) )
		{
			$this->arrExpressionAttrs[] = $sLowerAttrName ;
		}
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsExpressionAttribute($sAttrName)
	{
		$sLowerAttrName = strtolower($sAttrName) ;
		$sDyAttrName = $sLowerAttrName.'.expression' ;
		$sDyAttrValue = $this->GetAttribute($sDyAttrName) ;
		
		if( in_array($sLowerAttrName,$this->arrExpressionAttrs) )
		{
			return !in_array( $sDyAttrValue, array('0','false','off','no') ) ;
		}
		
		else
		{
			return in_array( $sDyAttrValue, array('1','true','on','yes') ) ;
		}
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	private $arrAttributes = array() ;
	
	private $arrAttributeOriginNames = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrExpressionAttrs = array() ;
}
?>