<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlNodeTag.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlNodeTag extends JCAT_UIHtmlObject
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sSource		What's this Parameter ?
	 * @param	$sName		What's this Parameter ?
	 * @param	$nType		What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_UIHtmlNodeTag(  $sSource,  $sName,  $nType ) 
	{
		JCAT_ASSERT::ASSERT_INT($nType) ;
		JCAT_ASSERT::ASSERT_( in_array($nType,array(self::TYPE_HEAD,self::TYPE_TAIL)), JCAT_Language::SentenceEx('参数 $nType 必须为 JCAT_UIHtmlNodeTag::TYPE_HEAD 或 JCAT_UIHtmlNodeTag::TYPE_TAIL','JCAT',null) ) ;
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		
		
		$this->JCAT_UIObject($sSource) ;
		$this->sName = $sName ;
		$this->nType = $nType ;
	}

	/**
	 * 
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetTagType()
	{ return $this->nType ; }
	
	/**
	 * 取得标签名称
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTagName()
	{ return $this->sName ; }
	
	/**
	 * 取得标签的顶级名称空间
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTagTopName()
	{
		list($sTopName,) = explode(':',$this->sName) ;
		return $sTopName ;
	}
	
	
	public function SetTagAttributeSource( $sAttributeSource )
	{
		JCAT_ASSERT::ASSERT_STRING($sAttributeSource) ;
		
		$old_value = $this->sAttributeSource ;
		$this->sAttributeSource = $sAttributeSource ;
		return $old_value ;
	}
	
	public function GetTagAttributeSource()
	{ return $this->sAttributeSource ; }
	
	/**
	 * 判断是否与 给入的标签匹配，构成一个成对的节点
	 *
	 * @access	public
	 * @param	$aTailTag	JCAT_UIHtmlNodeTag	What's this Parameter ?
	 * @return	bool
	 */
	public function MatchTail( JCAT_UIHtmlNodeTag $aTailTag )
	{
		if( $aTailTag->GetTagType()!=self::TYPE_TAIL )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx('参数 $aTailTag 必须是一个尾标签','JCAT',null), __macro_exception_code__ ) ;
		}

		$sTailName = $aTailTag->GetTagName() ;
		return preg_match("/^{$sTailName}/i",$this->GetTagName()) ;
	}
	


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	const
	 * @var		
	 */
	const TYPE_HEAD = 1 ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	const
	 * @var		
	 */
	const TYPE_TAIL = 2 ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sName ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		
	 */
	private $nType ;


	private $sAttributeSource ;
	
}
?>