<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIHtmlObject.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * UI.Html.Object
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIHtmlObject extends JCAT_UIObject
{

	/**
	 * 置换编译内容
	 * 
	 * @access	public
	 * @param	$nStart			int		开始位置
	 * @param	$nLen			int		長度
	 * @param	& $sNewContent	string	内容
	 * @return	void
	 */
	protected function _ReplaceCompiled($nStart,$nLen,&$sNewContent)
	{
		JCAT_ASSERT::ASSERT_INT($nStart) ;
		JCAT_ASSERT::ASSERT_INT($nLen) ;
		JCAT_ASSERT::ASSERT_STRING($sNewContent) ;
		
		$sCompiled = $this->GetCompiled() ;
		$sCompiled = substr_replace( $sCompiled, $sNewContent, $nStart, $nLen ) ;
		$this->SetCompiled( &$sCompiled ) ;
	}

	/**
	 * 编译
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Compile() 
	{
		// 从后向前 编译 子对象
		$aIterator = $this->CreateUIObjectIterator() ;
		$aIterator->Last() ;
		

		while( !$aIterator->IsDone() )
		{
			$aChildUIObject = $aIterator->Current() ;
			JCAT_ASSERT::ASSERT_INSTANCE($aChildUIObject,'JCAT_UIHtmlObject') ;
			
			// 编译子对象
			$aChildUIObject->Compile() ;
			
			// 置换 对象
			$nStart = $aChildUIObject->GetStartByte() - $this->GetStartByte() ;
			$nLen = $aChildUIObject->GetEndByte() - $aChildUIObject->GetStartByte() + 1 ;
			$this->_ReplaceCompiled($nStart, $nLen, $aChildUIObject->GetCompiled()) ;
		
			// 迭代至上一个
			$aIterator->Previous() ;
		}
		

		// 编译自己
		JCAT_UIObject::Compile() ;
	}


	/**
	 * create a Exception
	 *
	 * @access	public
	 * @param	$sMsg=''		string		异常消息
	 * @param	$nCode=0		int		JCAT异常ID
	 * @return	JCAT_Exception
	 */
	public function CreateException($sMsg='',$nCode=0)
	{
		return new JCAT_UIHtmlObjectException($this,$sMsg,$nCode) ;
	}

}
?>