<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UIObjectProcessorManager.php 1842 2009-05-19 12:25:18Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



include_once (dirname(__FILE__).'/interface.JCAT_IUIObjectProcessorManager.php') ;



/**
 * UI对象处理管理器
 *
 * @author		alee
 * @access		public
 */
class JCAT_UIObjectProcessorManager implements JCAT_IUIObjectProcessorManager
{

	/**
	 * 注册一个处理器
	 * 
	 * @access	public
	 * @param	$sOperationName		string													业务名称
	 * @param	$Processor			string,JCAT_IUIObjectParser,JCAT_IUIObjectCompiler		对象处理器 或 处理器类名
	 * @return	old_value
	 */
	public function RegisterProcessor(  $sOperationName,  $Processor )
	{
		JCAT_ASSERT::ASSERT_STRING($sOperationName) ;
		JCAT_ASSERT::ASSERT_ISTHESE($Processor,array('string','JCAT_IUIObjectParser','JCAT_IUIObjectCompiler')) ;
		
		// 检查 是否有效 的 类名
		$sExceptionMsg = JCAT_Language::SentenceEx('参数 $Processor 如果为string类型，必须是一个有效的类名，且该类实现了 JCAT_IUIObjectParser 或者 JCAT_IUIObjectCompiler 接口','JCAT',null) ;
		if( is_string($Processor) )
		{
			if( !class_exists($Processor) or ( !JCAT_Global::HasImplementedTo($Processor,'JCAT_IUIObjectParser') and !JCAT_Global::HasImplementedTo($Processor,'JCAT_IUIObjectCompiler') ) )
					throw new JCAT_Exception( $sExceptionMsg, JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
		}
		
		$old_value = isset($this->arrProcessors[ $sOperationName ])? $this->arrProcessors[ $sOperationName ]: null ;
		$this->arrProcessors[ $sOperationName ] = $Processor ;
		return $old_value ;			
	}



	/**
	 * 取消一个处理器
	 * 
	 * @access	public
	 * @param	$sOperationName	string	业务名称
	 * @return	void
	 */
	public function UnregisterProcessor( string $sOperationName )
	{ unset( $this->arrProcessors[$sOperationName] ) ; }



	/**
	 * 取回一个处理器
	 * 
	 * @access	public
	 * @param	$sOperationName	string		业务名称
	 * @return	JCAT_IUIObjectParser,JCAT_IUIObjectCompiler,null
	 */
	public function GetProcessor( $sOperationName )
	{
		if( !isset($this->arrProcessors[$sOperationName]) )
		{
			return null ;
		}
		
		// 创建一个单件对象 并返回
		if( is_string($this->arrProcessors[$sOperationName]) )
		{
			include_once JCATPATH.'/Lib.php/Common/Pattern/Singleton/class.JCAT_Singleton.php';
			return JCAT_Singleton::GetGlobalInstance( $this->arrProcessors[$sOperationName] ) ;
		}
		
		return $this->arrProcessors[$sOperationName] ;
	}



	/**
	 * 为 所有处理器创建一个迭代器
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateProcessorIterator()
	{
		$this->AutoloadProcessor() ;
		
		return new JCAT_ArrayIterator( $this->arrProcessors ) ;
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDir	string	目标目录
	 * @return	void
	 */
	public function AddAutoloadProcessorDir($sDir)
	{
		$this->arrAutoloadProcessorDirs[] = $sDir ;
	}


	/**
	 * 自动加载给定目录下的类
	 * 
	 * @access	public
	 * @return	void
	 */
	public function AutoloadProcessor()
	{
		$arrRes = array() ;
		
		foreach( $this->arrAutoloadProcessorDirs as $sIdx=>$sDir )
		{
			// 载入所有php文件
			$aIterator = new JCAT_FSOIterator($sDir,JCAT_FSOIterator::FILE|JCAT_FSOIterator::RETURN_FSO) ;
			while( !$aIterator->IsDone() )
			{
				$aFile = $aIterator->Current() ;
				
				// 检查 文件名 是否合乎
				if( preg_match('/^class\.([^\.]+)\.php/i',$aFile->GetName(),$arrRes) )
				{
					$sClassName = $arrRes[1] ;
					
					// 载入类文件
					if(!JCAT_Package::ClassExists($sClassName))
					{
						include_once $aFile->GetPath() ;
					}
						
					// 检查同名的类 是否存在			
					if( !class_exists($sClassName) )
					{
						throw new JCAT_Exception( JCAT_Language::SentenceEx('文件：“%s” 没有发现同名的 类','JCAT',null,$aFile->GetName()), JCAT_Exception::MakeExceptionCode(__CLASS__,2) ) ;
					}
	
					// 检查该类是否实现必要接口
					//if( !JCAT_Global::HasImplementedTo($sClassName,'JCAT_IUIAutoloadableProcessor',true) )
					//	throw new JCAT_Exception( JCAT_Language::SentenceEx('类：“%s” 出现在UI对象处理器自动加载目录中，但是并未实现 JCAT_IUIAutoloadableProcessor 接口','JCAT',null,$sClassName), JCAT_Exception::MakeExceptionCode(__CLASS__,3) ) ;
					
					// 注册
					if( JCAT_Global::HasImplementedTo($sClassName,'JCAT_IUIAutoloadableProcessor',true) )
						call_user_func_array( array($sClassName,'RegistorToProcessorManager'), array($this) ) ;
	
				}
				
				$aIterator->Next() ;
			}
		
			unset($this->arrAutoloadProcessorDirs[$sIdx]) ;
		}
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 已注册的 对象处理器
	 * 
	 * @access	private
	 * @var		array:JCAT_IUIObjectParser,JCAT_IUIObjectCompiler
	 */
	private $arrProcessors ;

	/**
	 * Description
	 * 
	 * @access	private
	 * @var		arr
	 */
	private $arrAutoloadProcessorDirs = array() ;

}
/*macro_exception_code:3*/
?>