<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UITemplateFileManager.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UITemplateFileManager
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_UITemplateFileManager ( $sCacheFilename='inc.TemplateFileIndex.php' )
	{
		$this->sCacheFilename = $sCacheFilename ;
	}
	
	/**
	 * 设置一个模版文件存放目录
	 * 
	 * @access	public
	 * @param	$sDir	string	模版文件存放目录
	 * @static
	 * @return	void
	 */
	public function AddTemplateDir( $sDir ) 
	{
		// 目录
		JCAT_ASSERT::ASSERT_DIR($sDir) ;
		$sDirKey = JCAT_Global::TidyPath($sDir) ;
		
		$arrTemplateFiles = array() ;
		
		// use template index file
		if(self::$bUseTemplateIndexFile)
		{
			// 索引文件
			$sCacheFilePath = $this->GetTemplateIndexFilepath($sDir) ;
			$bCacheFileExists = is_file($sCacheFilePath) ;
			
			// 忽略缓存文件 或 无缓存文件
			if( JCAT_ProjectState::Get(JCAT_ProjectState::NO_CACHE) or !$bCacheFileExists )
			{
				$this->CreateTempateIndex($sDirKey,$sCacheFilePath) ;
			}
			
			// 读取索引文件
			$arrTemplateFiles = include $sCacheFilePath ;
		}
		
		// 直接遍历模板目录
		else 
		{
			$arrTemplateFiles = $this->IndexTemplateFiles($sDir) ;
		}
		
		$this->arrTemplateFiles[$sDirKey] = $arrTemplateFiles ;
		
		

		
	}



	/**
	 * 清空已经设置的模版文件目录
	 * 
	 * @access	public
	 * @static
	 * @return	int
	 */
	public function ClearTemplateDirs() 
	{
		$nCount = count($this->arrTemplateFiles) ;
		$this->arrTemplateFiles = array() ;
		return $nCount ;
	}



	/**
	 * 创建一个 模版目录  的备忘录
	 * 
	 * @access	public
	 * @static
	 * @return	array
	 */
	public function CreateTemplateDirsMemento() 
	{ return $this->arrTemplateFiles ; }



	/**
	 * 使用 一个备忘录
	 * 
	 * @access	public
	 * @param	$arrMemento	array	备忘录
	 * @static
	 * @return	old_var
	 */
	public function SetTemplateDirsMemento( array $arrMemento ) 
	{
		// 对备忘录的内容进行检查
		JCAT_ASSERT::ASSERT_ISTHESE($arrMemento,array('array:string')) ;
		foreach($arrMemento as $sDirKey=>$arrFilenames) 
		{
			JCAT_ASSERT::ASSERT_DIR( $sDirKey
				, JCAT_Language::SentenceEx('正在通过 JCAT_UITemplateFileManager::SetTemplateDirsMemento() 设置的备忘录中有一个无效的目录：%s','JCAT',null,$sDirKey)) ;
		}
		
		// 设置
		$old_var = $this->arrTemplateFiles ;
		$this->arrTemplateFiles = $arrMemento ;
		return $old_var ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @static
	 * @return	JCAT_ArrayReverseIterator
	 */
	public function CreateTemplateDirIterator() 
	{
		$arrTemplateDirs = array_keys($this->arrTemplateFiles) ;
		return JCAT_ArrayReverseIterator ($arrTemplateDirs) ;
	}
	
	/**
	 * 根据模版 文件名查找 文件
	 * 
	 * @access	public
	 * @param	$sTemplateFile					string	模版文件名称
	 * @static
	 * @return	string
	 */
	public function FindTemplate( $sTemplateFile )
	{
		include_once JCATPATH.'Lib.php/Common/Pattern/Iterator/class.JCAT_ArrayReverseIterator.php' ;
		$aIterator = new JCAT_ArrayReverseIterator($this->arrTemplateFiles) ;
		while( !$aIterator->IsDone() )
		{
			$arrFiles = $aIterator->Current() ;
			$sDir = $aIterator->CurrentKey() ;
			
			if( in_array($sTemplateFile,$arrFiles) )
			{
				return $sDir.$sTemplateFile ;
			}
			
			$aIterator->Next() ;
		}
		
		return null ;
	}
	
	/**
	 * 载入模版目录中的模板文件
	 * 
	 * @access	public
	 * @static
	 * @return	void
	 */
	public function CreateTempateIndex($sDirPath,$sCacheFilePath=null)
	{
		$sDirPath = JCAT_Global::TidyPath($sDirPath) ;
		
		$sCacheFileContent = '<'."?\r\nreturn " ;
		
		// 文件索引
		$arrFilenames = $this->IndexTemplateFiles($sDirPath) ;
		$sCacheFileContent.= var_export($arrFilenames,true) ;
		
		$sCacheFileContent.= "\r\n ?".'>' ;
		
		// 创建文件索引缓存
		if($sCacheFilePath===null)
		{
			$sCacheFilePath = $this->GetTemplateIndexFilepath($sDirPath) ;
		}
		file_put_contents($sCacheFilePath,$sCacheFileContent) ;
		chmod($sCacheFilePath,0777) ;
	}
	
	/**
	 * 返回模板索引文件路径
	 * 
	 * @access	private
	 * @static
	 * @return	array
	 */
	private function IndexTemplateFiles($sDirPath)
	{
		$arrFilenames = array() ;
		
		// 迭代索引 所有文件
		$aIterator = new JCAT_FSOIterator($sDirPath,JCAT_FSOIterator::FILE|JCAT_FSOIterator::RETURN_NAME) ;
		for( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$arrFilenames[] = $aIterator->Current() ;
		}
		
		return $arrFilenames ;
	}
	
	/**
	 * 返回模板索引文件路径
	 * 
	 * @access	protected
	 * @static
	 * @return	string
	 */
	protected function GetTemplateIndexFilepath($sDirPath)
	{
		return $sDirPath.'/'.$this->sCacheFilename ;
	}
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrTemplateFiles = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sCacheFilename ;
	
	/**
	 * 是否使用索引文件
	 * 
	 * @access	public
	 * @static 
	 * @var		bool
	 */
	static public $bUseTemplateIndexFile = false ;
	
}

?>