<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_PDR.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * PHP桌面运行时 （PHP Desktop Runtime，简写 PDR） 相关功能
 *
 * @author		alee
 * @access		public
 */
class JCAT_PDR
{

	
	/**
	 * 通过 PDR 以子进程执行一个 PHP 脚本
	 * 
	 * @access	public
	 * @param	$sScriptPath		string			脚本路径
	 * @param	$arrArgs=array()	array			参数
	 * @param	$bUseGConfD2=false	bool			是否使用 gconfd-2.exe
	 * @return	void
	 * @static
	 */
	static public function RunScript($sScriptPath,array $arrArgs=array(),$bUseGConfD2=false)
	{
		// 检查 PDR 是否安装
		if( !self::HasInstalled() )
		{
			throw new JCAT_Exception(JCAT_Language::Sentence("PHP桌面运行时 （PHP Desktop Runtime）尚未安装。\r\n\r\n请访问：http://pdr.JeCat.com",'JCAT',null),__macro_exception_code__) ;
		}
		
		// 获得 PDR  路径
		$sPDR = self::GetExcutor() ;
		$sGetGConfD2 = $bUseGConfD2? self::GetGConfD2(): null ;
		
		// 整理参数格式
		foreach ($arrArgs as &$sArg)
		{
			if( preg_match('/^[\'"].*[\'"]$/s',$sArg) )
			{
				$sArg = "\"{$sArg}\"" ;
			}
		}
		$sArgs = ' '.implode( ' ', $arrArgs ) ;
		
		// 组装命令
		if($sGetGConfD2===null)
		{
			$sCmd = "\"$sPDR\" -f \"{$sScriptPath}\"{$sArgs}" ;			
		}
		else 
		{
			$sCmd = "\"{$sGetGConfD2}\" \"$sPDR\" -f \"{$sScriptPath}\"{$sArgs}" ;
		}
		
		// 执行
		$arrOutputLines = array() ;
		exec($sCmd,$arrOutputLines) ;
		
		// 返回执行结果
		return implode("\r\n",$arrOutputLines) ;
	}
	
	
	/**
	 * 判断是否安装 PDR，以及 PDR 是否有效
	 * 
	 * @access	public
	 * @return	bool
	 * @static
	 */
	static public function HasInstalled()
	{
		// 获得  php.exe 路径
		$sPDR = self::GetExcutor() ;
		
		// 检查 php.exe 是否存在
		if(! is_file($sPDR) )
		{
			return false ;
		}
		
		// 检查 php.exe 是否具有可执行权限
		if(! is_executable($sPDR) )
		{
			return false ;
		}
		
		// 应该没问题了吧 ... ...
		return true ;		
	}
	
	
	/**
	 * 返回 PDR 的 php 执行文件的路径
	 * 
	 * @access	public
	 * @return	string,null
	 * @static
	 */
	static public function GetExcutor()
	{
		// 检查 环境变量 'PDR'
		if( !isset($_ENV[self::PDR_ENV_VARNAME]) )
		{
			return null ;
		}

		return $_ENV[self::PDR_ENV_VARNAME] ;
	}

	/**
	 * 返回 gconfd-2.exe
	 * 此函数 仅在 windows 平台有意义
	 * 
	 * @access	public
	 * @return	string,null
	 * @static
	 */
	static public function GetGConfD2()
	{
		// 检查 环境变量 'PDR'
		if( !isset($_ENV[self::PDR_GCONFD2_ENV_VARNAME]) )
		{
			return null ;
		}

		return $_ENV[self::PDR_GCONFD2_ENV_VARNAME] ;
	}
	
	
	/**
	 * PDR 在操作系统中的环境变量名称
	 * 
	 * @access	const
	 * @var		string
	 */
	const PDR_ENV_VARNAME = 'PDR' ;
	
	/**
	 * gconfd-2.exe 在操作系统中的环境变量名称
	 * 
	 * @access	const
	 * @var		string
	 */
	const PDR_GCONFD2_ENV_VARNAME = 'PDR_GCONFD2' ;

}
?>