<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ProjectState.php 1852 2009-05-20 13:41:07Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

//


/**
 * 设定项目进度状态（Debug, Release 或其他）
 *
 * @author		alee
 * @access		public
 */
class JCAT_ProjectState
{


	/**
	 * 设置一个状态
	 * 
	 * @access	public
	 * @param	$nFlag			int		状态标记
	 * @param	$bRemove=false	bool	移除
	 * @static
	 * @return	void
	 */
	static public function Set( $nFlag, $bSet=true ) 
	{
		// 设置
		if($bSet)
			self::$nFlag|= $nFlag ;

		// 移除
		else
			self::$nFlag = (self::$nFlag&(~$nFlag)) ;
	}



	/**
	 * 返回一个状态
	 * 
	 * @access	public
	 * @param	$nFlag	int		状态标记
	 * @static
	 * @return	bool
	 */
	static public function Get( $nFlag ) 
	{ return (self::$nFlag&$nFlag)? true: false ; }

	
	




	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 状态：启用断言
	 * 
	 * @access	const
	 * @var		int
	 */
	const ASSERT = 1 ;

	/**
	 * 状态：启用 VariableWatch （变量查看）
	 * 
	 * @access	const
	 * @var		int
	 */
	const VAR_WATCH = 2 ;

	/**
	 * 状态：数据库执行信息输出
	 * 
	 * @access	const
	 * @var		int
	 */
	const DB_EXCEPTION = 4 ;
	
	/**
	 * 状态组：Debug ，开启所有 状态
	 * 
	 * @access	const
	 * @var		
	 */
	const DEBUG = 7 ;

	/**
	 * 状态组：Release ，关闭所有 状态
	 * 
	 * @access	const
	 * @var		int
	 */
	const RELEASE = 0 ;

	/**
	 * 状态：不使用缓存的 JS 
	 * 
	 * @access	const
	 * @var		int
	 */
	const NO_CACHE = 8 ;

	/**
	 * 状态：强制编译UI模版
	 * 
	 * @access	const
	 * @var		int
	 */
	const UI_FORCE_COMPLETE = 16 ;

	/**
	 * 当前项目状态
	 * 
	 * @access	protected
	 * @var		int
	 */
	static protected $nFlag = self::DEBUG ;


}
/*macro_exception_code:0*/
?>