<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Version.php 1641 2009-04-09 09:37:41Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 版本号类
 *
 * @author		alee
 * @access		public
 */
class JCAT_Version
{


	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$nPrimaryNum				int		主版本号(架构版本号)，用于区分不同的架构
	 * @param	$nSecondaryNum=0			int		次版本号(接口版本号)，用于区分不同的接口
	 * @param	$nModificatoryNum=0		int		修正本号(修正版本号)，用于区分每次局部修改
	 * @param	$nInternalNum=0			int		内部本号，通常为 CVS 或 SVN 版本号
	 * @param	$sVersionCode=''			string	内部代号，例如 alpha, beta, rc 等
	 * @static
	 * @return	string
	 */
	public function JCAT_Version( $nPrimaryNum, $nSecondaryNum=0, $nModificatoryNum=0, $nInternalNum=0, $sVersionCode='' ) 
	{
		$this->nPrimaryNum = $nPrimaryNum ;
		$this->nSecondaryNum = $nSecondaryNum? $nSecondaryNum: 0 ;
		$this->nModificatoryNum = $nModificatoryNum? $nModificatoryNum: 0 ;
		$this->nInternalNum = $nInternalNum? $nInternalNum: 0 ;
		
		$this->sVersionCode = $sVersionCode ;
	}
	
	public function SetVersionCode($sVersionCode='')
	{
		$this->sVersionCode = $sVersionCode ;
	}
	
	/**
	 * 比较
	 *  返回值小于0 表示 低于 $aTo 版本
	 *  返回值等于0 表示 两个版本相等
	 *  返回值大于0 表示 高于 $aTo 版本
	 * 仅比较 主版本、次版本、修正版本， 不对 内部版本、版本代号 进行比较
	 * 
	 *
	 * @access	public
	 * @param	$aTo		JCAT_Version
	 * @return	int
	 */
	public function Compare(JCAT_Version $aTo)
	{
		// 比较主版本
		if( $this->GetPrimaryNumber() > $aTo->GetPrimaryNumber() )
		{
			return 1 ;
		}
		
		else if( $this->GetPrimaryNumber() < $aTo->GetPrimaryNumber() )
		{
			return -1 ;
		}
		
		else
		{
			// 比较 次版本
			if( $this->GetSecondaryNumber() > $aTo->GetSecondaryNumber() )
			{
				return 1 ;
			}
			
			else if( $this->GetSecondaryNumber() < $aTo->GetSecondaryNumber() )
			{
				return -1 ;
			}
			
			else 
			{
				// 比较修正版本
				if( $this->GetModificatoryNumber() > $aTo->GetModificatoryNumber() )
				{
					return 1 ;
				}
				
				else if( $this->GetModificatoryNumber() < $aTo->GetModificatoryNumber() )
				{
					return -1 ;
				}
				
				else 
				{
					return 0 ;
				}
				
			}	
		}
	}
	
	/**
	 * 转换为 字符串 格式
	 *
	 * @access	public
	 * @return	string
	 */
	public function __toString()
	{
		return $this->toString(true) ;
	}
	
	/**
	 * 转换为 字符串 格式
	 *
	 * @access	public
	 * @param 	$bFull=true		booll
	 * @return	void
	 */
	public function toString($bFull=true)
	{
		$sVersion = "{$this->nPrimaryNum}.{$this->nSecondaryNum}.{$this->nModificatoryNum}" ;
		
		if(!$bFull)
		{
			return $sVersion ;
		}
		
		else 
		{
			$sVersion.= '.'.$this->nInternalNum ;
			
			if($this->sVersionCode)
			{
				$sVersion.= ' '.$this->sVersionCode ;
			}
			
			return $sVersion ;
		}
	}
	
	/**
	 * 取得主版本号
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPrimaryNumber()
	{
		return $this->nPrimaryNum ;
	}
	
	/**
	 * 取得次版本号
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetSecondaryNumber()
	{
		return $this->nSecondaryNum ;
	}
	
	/**
	 * 取得修正版本号
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetModificatoryNumber()
	{
		return $this->nModificatoryNum ;
	}
	
	/**
	 * 取得内部版本号
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetInternalNumber()
	{
		return $this->nInternalNum ;
	}
	
	/**
	 * 取得版本代号
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetVersionCode()
	{
		return $this->sVersionCode ;
	}
	
	/**
	 * 取得版本号的32位整数格式
	 *  主版本号				5位			max:32
	 *  次版本号				5位			max:32
	 *  修正版本号			7位			max:128
	 *  内部版本号(svn)		15位			max:32768
	 *
	 * @access	public
	 * @return	int
	 */
	public function Get32Integer()
	{
		return	($this->GetPrimaryNumber()<< (self::INT32_BIT_INTERNAL+self::INT32_BIT_MODIFICTORY+self::INT32_BIT_SECONDARY) )
				+ ($this->GetSecondaryNumber()<< (self::INT32_BIT_INTERNAL+self::INT32_BIT_MODIFICTORY) )
				+ ($this->GetModificatoryNumber()<< self::INT32_BIT_INTERNAL )
				+ $this->GetInternalNumber() ;
	}
	
	/**
	 * 取得版本号补数的32位整数格式
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetCeil32Integer()
	{		
		// 主版本号
		$sPrimaryNumber = $this->GetPrimaryNumber() ;
		$sSecondaryNumber = $this->GetSecondaryNumber() ;
		$sModificatoryNumber = $this->GetModificatoryNumber() ;
		$tsInternalNumber = $this->GetInternalNumber() ;
		
		// 从 内部版本号 开始
		if( $tsInternalNumber===0 )
		{
			$tsInternalNumber = pow(2,self::INT32_BIT_INTERNAL) - 1 ;
			
			// 修正版本号
			if( $sModificatoryNumber===0 )
			{
				$sModificatoryNumber = pow(2,self::INT32_BIT_MODIFICTORY) - 1 ;
			
				// 次版本号
				if( $sSecondaryNumber===0 )
				{
					$sSecondaryNumber = pow(2,self::INT32_BIT_SECONDARY) - 1 ;

					// 主版本号
					if( $sPrimaryNumber===0 )
					{
						$sPrimaryNumber = pow(2,self::INT32_BIT_PRIMARY) - 1 ;
					}
				}
			}
		}


		return	($sPrimaryNumber<< (self::INT32_BIT_INTERNAL+self::INT32_BIT_MODIFICTORY+self::INT32_BIT_SECONDARY) )
				+ ($sSecondaryNumber<< (self::INT32_BIT_INTERNAL+self::INT32_BIT_MODIFICTORY) )
				+ ($sModificatoryNumber<< self::INT32_BIT_INTERNAL )
				+ $tsInternalNumber ;
	}
	
	/**
	 * 通过32位整数格式 返回 一个 版本对象
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	static public function From32Integer($n32Version,$sVerCode='')
	{
		// 转换为 二进制
		$sDecVersion = decbin($n32Version) ;
		
		// 补齐 32位
		$sDecVersion = str_repeat('0',32-strlen($sDecVersion)).$sDecVersion ;
		
		$nPrimaryVer = bindec(substr($sDecVersion,0,self::INT32_BIT_PRIMARY)) ;
		$nSecondaryVer = bindec(substr(
							$sDecVersion
							, self::INT32_BIT_PRIMARY
							, self::INT32_BIT_SECONDARY)) ;
		$nModificatoryVer = bindec(substr(
							$sDecVersion
							, self::INT32_BIT_PRIMARY + self::INT32_BIT_SECONDARY
							, self::INT32_BIT_MODIFICTORY)) ;
		$nInternalVer = bindec(substr(
							$sDecVersion
							, self::INT32_BIT_PRIMARY + self::INT32_BIT_SECONDARY + self::INT32_BIT_MODIFICTORY
							, self::INT32_BIT_INTERNAL)) ;
		
		return new JCAT_Version($nPrimaryVer,$nSecondaryVer,$nModificatoryVer,$nInternalVer,$sVerCode) ;
	}
	
	/**
	 * 通过字串格式 返回 一个 版本对象
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	static public function FromString($sVersion)
	{
		JCAT_ASSERT::ASSERT_( self::VerifyFormat($sVersion), JCAT_Language::SentenceEx('输入的字串“%s”不是合法的版本号格式。','JCAT',null,$sVersion) )  ;
		
		//@list($sVersion,$sCode) = explode(' ',$sVersion) ;
		$arrVersionSegments = explode(' ',$sVersion) ;
		$sVersion = $arrVersionSegments[0] ;
		$sCode = isset($arrVersionSegments[1])? $arrVersionSegments[1]: '' ;
		
		//@list($nPrimaryVer,$nSecondaryVer,$nSecondaryVer,$nInternalVer) = explode('.',$sVersion) ;
		$arrVersionSegments = explode('.',$sVersion) ;
		$nPrimaryVer = isset($arrVersionSegments[0])? $arrVersionSegments[0]: 0 ;
		$nSecondaryVer = isset($arrVersionSegments[1])? $arrVersionSegments[1]: 0 ;
		$nModificatoryVer = isset($arrVersionSegments[2])? $arrVersionSegments[2]: 0 ; 
		$nInternalVer = isset($arrVersionSegments[3])? $arrVersionSegments[3]: 0 ;
		
		return new JCAT_Version($nPrimaryVer,$nSecondaryVer,$nModificatoryVer,$nInternalVer,$sCode) ;
	}
	
	/**
	 * 判断是否为合法的 版本号格式 字串
	 *
	 * @access	public
	 * @param	$sVersion		string	
	 * @static
	 * @return	bool
	 */
	static public function VerifyFormat($sVersion)
	{
		return preg_match('/^\d+(\.\d+){0,3}( [\w_\-]+)?$/',$sVersion) ;
	}
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 各个版本号
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nPrimaryNum = 0 ;
	private $nSecondaryNum = 0 ;
	private $nModificatoryNum = 0 ;
	private $nInternalNum = 0 ;
	
	
	/**
	 * 各个版本在 32整数 格式中的位宽
	 * 
	 *  主版本号				5位			max:32
	 *  次版本号				5位			max:32
	 *  修正版本号			7位			max:128
	 *  内部版本号(svn)		15位		max:32768
	 */
	const INT32_BIT_PRIMARY = 5 ;
	const INT32_BIT_SECONDARY = 5 ;
	const INT32_BIT_MODIFICTORY = 7 ;
	const INT32_BIT_INTERNAL = 15 ;
	/**
	 * 版本代号
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sVersionCode ;
}
?>