<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_VersionCompat.php 1637 2009-04-09 02:50:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 版本兼容类
 *
 * @author		alee
 * @access		public
 */
class JCAT_VersionCompat
{

	/**
	 * 增加兼容版本
	 * 
	 * @access	public
	 * @param	$aLow				JCAT_Version		下位版本
	 * @param	$aHigh＝null			JCAT_Version		上位版本
	 * @param	$bEqualLow=true		bool				下位相等
	 * @param	$bEqualHigh=true	bool				上位相等
	 * @return	void
	 */
	public function AddCompatibleVersion(JCAT_Version $aLow, JCAT_Version $aHigh=null, $bEqualLow=true, $bEqualHigh=true)
	{
		$this->arrScopes[] = new _JCAT_VersionScope($aLow,$aHigh,$bEqualLow,$bEqualHigh) ;
	}
	
	/**
	 * 增加兼容版本
	 * 
	 * @access	public
	 * @param	$sCompatibleVersions		string
	 * @return	void
	 */
	public function AddFromString($sCompatibleVersions)
	{
		$arrScopes = preg_split('/[\,;\r\n]/',$sCompatibleVersions,-1,PREG_SPLIT_NO_EMPTY) ;
		foreach($arrScopes as $sScope)
		{
			$this->arrScopes[] = _JCAT_VersionScope::FromString($sScope) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function MakeString()
	{
		$arrScopes = array() ;
		foreach ($this->arrScopes as $aScope)
		{
			$arrScopes[] = $aScope->MakeString() ;
		}
		
		return implode("\r\n",$arrScopes) ;
	}
	
	/**
	 * 清空兼容版本
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Clear()
	{
		$this->arrScopes[] = array() ;
	}
	
	
	/**
	 * 检查一个版本是否兼容
	 * 
	 * @access	public
	 * @param	$aVersion		JCAT_Version
	 * @return	bool
	 */
	public function Check(JCAT_Version $aVersion)
	{
		foreach ($this->arrScopes as $aScope)
		{
			if( $aScope->IsInScope($aVersion) )
			{
				return true ;
			}
		}
		
		return false ;
	}
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrScopes ;
}

/**
 * 版本范围类
 *
 * @author		alee
 * @access		public
 */
class _JCAT_VersionScope
{
	public function _JCAT_VersionScope(JCAT_Version $aLow, JCAT_Version $aHigh=null, $bEqualLow=true, $bEqualHigh=true)
	{
		$this->aLow = $aLow ;
		if($aHigh)
		{
			$this->aHigh = $aHigh ;
			$this->bEqualLow = $bEqualLow? true: false ;
			$this->bEqualHigh = $bEqualHigh? true: false ;
			$this->bScope = true ;
		}
		
		else
		{
			$this->aHigh = null ;
			$this->bEqualLow = true ;
			$this->bEqualHigh = false ;
			$this->bScope = false ;
		}
	}
	
	static public function FromString($sScopeString)
	{
		$arrRes = array() ;
		if( !preg_match('/^([\w\. _\-]+)((<\-|\->|<>|\-)([\w\. _\-])+)?$/',$sScopeString,$arrRes) )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx(
					'遇到错误的版本兼容范围：%s', 'JCAT', null, $sScopeString
			)) ;
		}

		$sLow = trim($arrRes[1]) ;
		$sSeparator = isset($arrRes[3])? trim($arrRes[3]): null ;
		$sHigh = isset($arrRes[4])? trim($arrRes[4]): null ;
		
		// 低位
		if( !JCAT_Version::VerifyFormat($sLow) )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx(
					'遇到错误的版本兼容范围：%s', 'JCAT', null, $sScopeString
			)) ;
		}
		$aLow = JCAT_Version::FromString($sLow) ;

		if(!$sHigh)
		{
			return new _JCAT_VersionScope($aLow) ;
		}
		
		else 
		{
			// 高位
			if( !JCAT_Version::VerifyFormat($sHigh) )
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx(
						'遇到错误的版本兼容范围：%s', 'JCAT', null, $sScopeString
				)) ;
			}
			$aHigh = JCAT_Version::FromString($sHigh) ;
			
			$bEqualLow = strstr($sSeparator,'<')===false ;
			$bEqualHigh = strstr($sSeparator,'>')===false ;
			
			return new _JCAT_VersionScope($aLow,$aHigh,$bEqualLow,$bEqualHigh) ;
		}
	}
	
	public function IsInScope(JCAT_Version $aVersion)
	{
		// 检查范围
		if( $this->bScope )
		{
			// 比较下位版本
			$nLow = $aVersion->Compare($this->aLow) ;
			if( ($this->bEqualLow and $nLow<0) or (!$this->bEqualLow and $nLow<=0) )
			{
				return false ;
			}
			
			// 比较上位版本
			$nHigh = $aVersion->Compare($this->aHigh) ;
			if( ($this->bEqualHigh and $nHigh>0) or (!$this->bEqualHigh and $nHigh>=0) )
			{
				return false ;
			}
			
			return true ;
		}
		
		// 指定版本
		else
		{
			return ($aVersion->Compare($this->aLow)==0) ;
		}
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function MakeString()
	{
		$sString = $this->aLow->toString(true) ;
		if( $this->aHigh )
		{
			$sString.= $this->bEqualLow? '-': '<' ;
			$sString.= $this->bEqualHigh? '-': '>' ;
			
			$sString.= $this->aHigh->toString(true) ;
		}
		
		return $sString ;
	}
	
	/**
	 * 下位版本号
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aLow ;
	
	/**
	 * 上位版本号
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aHigh ;
	
	/**
	 * 下位相等
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bEqualLow ;
	
	/**
	 * 上位相等
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bEqualHigh ;
	
	/**
	 * 是否是一个版本范围（或指定版本）
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bScope ;
	
	
}
?>