<?php
// Call JCAT_ASSERTTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_ASSERTTest::main');


require_once 'PHPUnit/Framework.php';
require_once 'PHPUnit/Extensions/ExceptionTestCase.php' ;

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/class.JCAT_ASSERT.php';

/**
 * Test class for JCAT_ASSERT.
 * Generated by PHPUnit on 2007-12-17 at 17:44:23.
 */
class JCAT_ASSERTTest extends PHPUnit_Extensions_ExceptionTestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_ASSERTTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	private $bProjectStateASSERT_old_value ;
	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
		//$this->bProjectStateASSERT_old_value = JCAT_ProjectState::Get(JCAT_ProjectState::ASSERT) ;
		JCAT_ProjectState::Set(JCAT_ProjectState::ASSERT) ;
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testASSERT_().
     */
    public function testASSERT_() {
		
		try{
			JCAT_ASSERT::assert_(false) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_(0) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_(1==2) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_(null) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_('') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		
		JCAT_ASSERT::assert_(true) ;
		JCAT_ASSERT::assert_(1) ;
		JCAT_ASSERT::assert_(new a()) ;
		JCAT_ASSERT::assert_('hi') ;
    }

    /**
     * @todo Implement testASSERT_INT().
     */
    public function testASSERT_INT() {
        
		JCAT_ASSERT::assert_int(1) ;
		JCAT_ASSERT::assert_int(a::aa) ;
		JCAT_ASSERT::assert_int(b) ;
		
		
		try{
			JCAT_ASSERT::assert_int('aa') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int(true) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int('zzzzz') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int(1.23) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_NUM().
     */
    public function testASSERT_NUM() {
        
		JCAT_ASSERT::assert_int(1) ;
		JCAT_ASSERT::assert_int(a::aa) ;
		JCAT_ASSERT::assert_int(b) ;
		
		
		try{
			JCAT_ASSERT::assert_int('aa') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int(true) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int('zzzzz') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int(1.23) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int(array(1.2)) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_int(new a()) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_STRING().
     */
    public function testASSERT_STRING() {
        
		JCAT_ASSERT::assert_string('hi') ;
		JCAT_ASSERT::assert_string(a::aaa) ;
		
		
		try{
			JCAT_ASSERT::assert_string(1) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_string(true) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_string(1,22) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_string(array(1.2,'yy')) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_string(new a()) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_BOOL().
     */
    public function testASSERT_BOOL() {
	
		JCAT_ASSERT::assert_bool(true) ;
		JCAT_ASSERT::assert_bool(false) ;
		JCAT_ASSERT::assert_bool(1==1) ;
		JCAT_ASSERT::assert_bool(1==0) ;
		
		
		try{
			JCAT_ASSERT::assert_bool(1) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_bool('ji') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_bool(1.22) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_bool(array(1,2,'yy')) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_bool(new a()) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_INSTANCE().
     */
    public function testASSERT_INSTANCE() {
        
		JCAT_ASSERT::assert_instance(new a()) ;
		JCAT_ASSERT::assert_instance(new b()) ;
		JCAT_ASSERT::assert_instance(new aa()) ;
		JCAT_ASSERT::assert_instance(new aaa()) ;
		
		JCAT_ASSERT::assert_instance(new a(),'a') ;
		JCAT_ASSERT::assert_instance(new b(),'b') ;
		JCAT_ASSERT::assert_instance(new aa(),'a') ;
		JCAT_ASSERT::assert_instance(new aa(),'aa') ;
		JCAT_ASSERT::assert_instance(new aaa(),'a') ;
		JCAT_ASSERT::assert_instance(new aaa(),'aaa') ;
		JCAT_ASSERT::assert_instance(new aaa(),'aaa') ;
		
		
		try{
			JCAT_ASSERT::assert_instance(new a(),'b') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_instance(new a(),'aa') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_instance(new aa(),'aaa') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_instance(1) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_instance('ji') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_instance(1.22) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::assert_instance(array(1,2,'yy')) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_ARRAY().
     */
    public function testASSERT_ARRAY() {
        
		JCAT_ASSERT::ASSERT_ARRAY(array()) ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1,2)) ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1,'ss')) ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1,'ss',new a())) ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1,'ss',array(2,3))) ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1,'ss'=>'ss','ee'=>new a())) ;
		
		
		JCAT_ASSERT::ASSERT_ARRAY(array('s','ss'=>'ss','ee'=>''),'string') ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1,'ss'=>2,'ee'=>3),'int') ;
		JCAT_ASSERT::ASSERT_ARRAY(array(true,'ss'=>false,'ee'=>true),'bool') ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1.2,'ss'=>2.3,'ee'=>6.4),'float') ;
		JCAT_ASSERT::ASSERT_ARRAY(array(1.2,'ss'=>2,'ee'=>6.4),'num') ;
		JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>new aa(),'ee'=>new aaa()),'a') ;
		JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>new aa(),'ee'=>new b()),'object') ;
		
		// 
		try{
			JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>new aa(),'ee'=>new b()),'a') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>new aa(),'ee'=>new aaa()),'aa') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>new aa(),'ee'=>new aaa()),'b') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>new aa(),'ee'=>new aaa()),'string') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>1,'ee'=>new aaa()),'object') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY(array(new a(),'ss'=>1,'ee'=>new aaa()),'a') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		
		// 普通类型
		try{
			JCAT_ASSERT::ASSERT_ARRAY(1) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY('ji') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY(1.22) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_ARRAY(new a()) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
    }

    /**
     * @todo Implement testASSERT_NULL().
     */
    public function testASSERT_NULL() {
        
		
		JCAT_ASSERT::ASSERT_NULL(null) ;
		
		try{
			JCAT_ASSERT::ASSERT_NULL(1) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_NULL(1.2) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_NULL(array(1,2)) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_NULL('hi') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_NULL(true) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_NULL(false) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_NULL(0) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_NULL('') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
    }

    /**
     * @todo Implement testASSERT_NOTNULL().
     */
    public function testASSERT_NOTNULL() {
        
		
		JCAT_ASSERT::ASSERT_NOTNULL(array()) ;
		JCAT_ASSERT::ASSERT_NOTNULL(1) ;
		JCAT_ASSERT::ASSERT_NOTNULL(1.2) ;
		JCAT_ASSERT::ASSERT_NOTNULL('hi') ;
		JCAT_ASSERT::ASSERT_NOTNULL(true) ;
		JCAT_ASSERT::ASSERT_NOTNULL(false) ;
		JCAT_ASSERT::ASSERT_NOTNULL(0) ;
		JCAT_ASSERT::ASSERT_NOTNULL('') ;
		
		
		try{
			JCAT_ASSERT::ASSERT_NOTNULL(null) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
    }

    /**
     * @todo Implement testASSERT_PATH().
     */
    public function testASSERT_PATH() {
        
		JCAT_ASSERT::ASSERT_PATH(dirname(__FILE__)) ;
		JCAT_ASSERT::ASSERT_PATH(dirname(__FILE__).'/') ;
		JCAT_ASSERT::ASSERT_PATH(dirname(__FILE__).'/.') ;
		JCAT_ASSERT::ASSERT_PATH(dirname(__FILE__).'/..') ;
		JCAT_ASSERT::ASSERT_PATH(__FILE__) ;
				
		try{
			JCAT_ASSERT::ASSERT_PATH(dirname(__FILE__).'/xvd/sdga') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_FILE().
     */
    public function testASSERT_FILE() {
        
		JCAT_ASSERT::ASSERT_FILE(__FILE__) ;
		
		// 目录
		try{
			JCAT_ASSERT::ASSERT_FILE(dirname(__FILE__)) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		// 无效路径
		try{
			JCAT_ASSERT::ASSERT_FILE(dirname(__FILE__).'/xxxddd/sss') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		// .
		try{
			JCAT_ASSERT::ASSERT_FILE(dirname(__FILE__).'/.') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		// ..
		try{
			JCAT_ASSERT::ASSERT_FILE(dirname(__FILE__).'/..') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_DIR().
     */
    public function testASSERT_DIR() {
        
		
		JCAT_ASSERT::ASSERT_DIR(dirname(__FILE__)) ;
		JCAT_ASSERT::ASSERT_DIR(dirname(__FILE__).'/') ;
		JCAT_ASSERT::ASSERT_DIR(dirname(__FILE__).'/.') ;
		JCAT_ASSERT::ASSERT_DIR(dirname(__FILE__).'/..') ;
		
		// 文件
		try{
			JCAT_ASSERT::ASSERT_DIR(__FILE__) ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		// 无效
		try{
			JCAT_ASSERT::ASSERT_DIR(dirname(__FILE__).'/xx/dkaj/dd') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_INHERIT().
     */
    public function testASSERT_INHERIT() {
        
		JCAT_ASSERT::ASSERT_INHERIT(new a(),'a') ;
		JCAT_ASSERT::ASSERT_INHERIT('a','a') ;
		
		JCAT_ASSERT::ASSERT_INHERIT(new aa(),'a') ;
		JCAT_ASSERT::ASSERT_INHERIT('aa','a') ;
		
		JCAT_ASSERT::ASSERT_INHERIT(new aaa(),'aa') ;
		JCAT_ASSERT::ASSERT_INHERIT('aaa','aa') ;
		
		
		try{
			JCAT_ASSERT::ASSERT_INHERIT(new aaa(),'b') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
		try{
			JCAT_ASSERT::ASSERT_INHERIT(new aa(),'aaa') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		
    }

    /**
     * @todo Implement testASSERT_IMPLEMENTS().
     */
    public function testASSERT_IMPLEMENTS() {
        
		JCAT_ASSERT::ASSERT_IMPLEMENTS('aa','i') ;
		JCAT_ASSERT::ASSERT_IMPLEMENTS(new aa(),'i') ;
		JCAT_ASSERT::ASSERT_IMPLEMENTS('aaa','i') ;
		JCAT_ASSERT::ASSERT_IMPLEMENTS(new aaa(),'i') ;
		
		try{
			JCAT_ASSERT::ASSERT_IMPLEMENTS(new a(),'i') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		try{
			JCAT_ASSERT::ASSERT_IMPLEMENTS('a','i') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		try{
			JCAT_ASSERT::ASSERT_IMPLEMENTS(new b(),'i') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
		try{
			JCAT_ASSERT::ASSERT_IMPLEMENTS('b','i') ;
			$this->fail((__LINE__-1).'行的断言未触发。') ;
		}
		catch(JCAT_ASSERTException $e){}
    }

    /**
     * @todo Implement testASSERT_ISTHESE().
     */
    public function testASSERT_ISTHESE() {
        
		JCAT_ASSERT::ASSERT_ISTHESE('aa',array('string')) ;
		JCAT_ASSERT::ASSERT_ISTHESE('aa','string') ;
		JCAT_ASSERT::ASSERT_ISTHESE(1,array('string','int')) ;
		JCAT_ASSERT::ASSERT_ISTHESE(array(1,2),array('string','int','array')) ;
    }
}


define('b',12) ;
define('bb','hi') ;

class a {
	const aa = 10 ;
	const aaa = 'hi' ;
	const aaaa = '123' ;
}

interface i {} 
class aa extends a implements i {}
class aaa extends aa {}

class b {}

// Call JCAT_ASSERTTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_ASSERTTest::main')
	JCAT_ASSERTTest::main();
?>
