<?php
// Call JCAT_GlobalTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_GlobalTest::main');


require_once 'PHPUnit/Framework.php';
require_once 'PHPUnit/Extensions/OutputTestCase.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/class.JCAT_Global.php';

/**
 * Test class for JCAT_Global.
 * Generated by PHPUnit on 2007-12-17 at 17:16:47.
 */
class JCAT_GlobalTest extends PHPUnit_Extensions_OutputTestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_GlobalTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testPrintVar().
     */
    public function testPrintVar() {
        
		$this->assertEquals(JCAT_Global::PrintVar(false),'false') ;
		$this->assertEquals(JCAT_Global::PrintVar(true),'true') ;
		$this->assertEquals(JCAT_Global::PrintVar(null),'null') ;
		$this->assertEquals(JCAT_Global::PrintVar(1),'1') ;
		$this->assertEquals(JCAT_Global::PrintVar(11),'11') ;
    }

    /**
     * @todo Implement testT().
     */
    public function testT() {
        
		$this->assertEquals(JCAT_Global::t(),1) ;
		$this->assertEquals(JCAT_Global::t(),2) ;
		$this->assertEquals(JCAT_Global::t(),3) ;
		$this->assertEquals(JCAT_Global::t(),4) ;
    }

    /**
     * @todo Implement testIsKindOf().
     */
    public function testIsKindOf() {
       
	   $a = new a() ;
	   $aa = new aa() ;
	   $aaa = new aaa() ;
	   $b = new b() ;
	   
	   $this->assertTrue( JCAT_Global::IsKindOf($a,'a') ) ;
	   $this->assertTrue( JCAT_Global::IsKindOf($aa,'a') ) ;
	   $this->assertTrue( JCAT_Global::IsKindOf($aaa,'a') ) ;
	   $this->assertTrue( JCAT_Global::IsKindOf($aa,'aa') ) ;
	   $this->assertTrue( JCAT_Global::IsKindOf($aaa,'aa') ) ;
	   $this->assertTrue( JCAT_Global::IsKindOf($aaa,'aaa') ) ;
	   
	   $this->assertFalse( JCAT_Global::IsKindOf($b,'a') ) ;
	   $this->assertFalse( JCAT_Global::IsKindOf($b,'aa') ) ;
	   $this->assertFalse( JCAT_Global::IsKindOf($b,'aaa') ) ;
	   
	   $this->assertFalse( JCAT_Global::IsKindOf($a,'aaa') ) ;
	   $this->assertFalse( JCAT_Global::IsKindOf($a,'aa') ) ;
	   $this->assertFalse( JCAT_Global::IsKindOf($aa,'aaa') ) ;
    }

    /**
     * @todo Implement testHasImplementedTo().
     */
    public function testHasImplementedTo() {
        
		$this->assertTrue(JCAT_Global::HasImplementedTo('d','i')) ;
		$this->assertFalse(JCAT_Global::HasImplementedTo('d','i',true)) ;
		
		$this->assertTrue(JCAT_Global::HasImplementedTo('e','i')) ;
		$this->assertTrue(JCAT_Global::HasImplementedTo('e','i',true)) ;
		
		$e = new e() ;
		$this->assertTrue(JCAT_Global::HasImplementedTo($e,'i')) ;
		$this->assertTrue(JCAT_Global::HasImplementedTo($e,'i',true)) ;
		
    }

    /**
     * @todo Implement testArray2UrlQeruy().
     */
    public function testArray2UrlQeruy() {
		
		$array = array( 'a'=>'aa', 'b'=>'bb' , 'c'=>array('dd'=>1,'ee'=>false,'ff'=>new a())) ;
		$this->assertEquals( JCAT_Global::Array2UrlQeruy($array,'array'),'array%5Ba%5D=aa&array%5Bb%5D=bb&array%5Bc%5D%5Bdd%5D=1&array%5Bc%5D%5Bee%5D=' ) ;
    }

    /**
     * @todo Implement testFormatOut().
     */
    public function testFormatOut() {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
          'This test has not been implemented yet.'
        );
    }
	
    /**
     * @todo Implement testMakeFunctionAlias().
     */
    public function testMakeFunctionAlias() {
        
		JCAT_Global::MakeFunctionAlias('f',array('c','cc')) ;
		JCAT_Global::MakeFunctionAlias('ff','ccc') ;
		
		
	   $this->assertTrue( f(20,30)==50 ) ;
	   $this->assertTrue( ff(20,50)==1000 ) ;
    }

    /**
     * @todo Implement testMakeClassAlias().
     */
    public function testMakeClassAlias() {
		
		JCAT_Global::MakeClassAlias('z','c') ;
		$e = new z() ;
		$this->assertTrue( $e->ccc()=='c::ccc()' ) ;
    }

    /**
     * @todo Implement testIsThese().
     */
    public function testIsThese() {
		
		
		$a = 'hi' ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('string')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('object','array')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','string')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','bool','base')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','bool','scalar')) ) ;
		
		$a = 1 ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('string')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('object','array')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','string')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('integer','bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('num','bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('numeric','bool','float')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('bool','base')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('bool','scalar')) ) ;
		
		$a = false ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('string','b')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('object','array')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','string','a')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','base')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','scalar')) ) ;
		
		$a = 1.2 ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('string','b')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('object','array')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','string','a')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('bool','float')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('bool','num')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('bool','numeric')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','bool','base')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','bool','scalar')) ) ;
		
		
		$a = fopen(__FILE__,'r') ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('string','b')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('object','array')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','string','a')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','float')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','float')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','num')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','numeric')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','base')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','scalar')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('resource','bool','scalar')) ) ;
		fclose($a) ;
		
		
		$a = array(1,2,3) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('string','b')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('object','array')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','string','a')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','float')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','float')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','num')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','numeric')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','base')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','scalar')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('resource','array','scalar')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('resource','array:int','scalar')) ) ;
		
		
		$a = array(1,'a',3) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('resource','array:int,string,float','scalar')) ) ;
		
		$a = new aa() ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('string','a')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('object','array')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('int','string','a')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','float')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','float')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','num')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('bool','numeric')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','base')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('int','bool','scalar')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('resource','object','scalar')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('resource','a','scalar')) ) ;
		$this->assertTrue( JCAT_Global::IsThese($a,array('resource','aa','scalar')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('resource','aaa','base')) ) ;
		$this->assertFalse( JCAT_Global::IsThese($a,array('resource','b','base')) ) ;
		
    }
	
	
    /**
     * @todo Implement testTidyPath().
     */
    public function testTidyPath() {

		$this->assertEquals( JCAT_Global::TidyPath('c:\\xxx\\sss\\aaa'), 'c:\\xxx/sss/aaa' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('c:\\xxx\\sss\\aaa',false), 'c:\\xxx\\sss\\aaa' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('c:\\xxx\\..\\sss\\..\\aaa'), 'c:\\aaa' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('c:\\xxx\\.\\sss\\.\\aaa'), 'c:\\xxx/sss/aaa' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('c:\\xxx\\..\\sss\\.\\aaa'), 'c:\\sss/aaa' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('c:\\.\\sss\\aaa\\.'), 'c:\\sss/aaa/' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('/xx/dd/ww/..'), '/xx/dd/' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('/xx/dd/ww/..',false), '\\xx\\dd\\' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('/xx/.dd/ww/..',false), '\\xx\\.dd\\' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('/xx/.dd/ww/../../ss',false), '\\xx\\ss' ) ;
		$this->assertEquals( JCAT_Global::TidyPath('/xx/.dd/ww/../ss/dd/.././../',false), '\\xx\\.dd\\' ) ;
	}
	
	
    /**
     * @todo Implement testTidyPath().
     */
    public function testCreateObject() {

		$e = new e() ;
		$e->n = 20 ;
		
		$kk = JCAT_Global::CreateObject('kk',array(array(1),$e)) ;
		$this->assertEquals($kk->arrN[0],1) ;
		$this->assertEquals($kk->aM->n,20) ;
	}
}



class a
{}

class aa extends a
{}

class aaa extends aa
{}

class b 
{}

class c
{
	static function cc($n,$m)
	{ return $n+$m ;}
	
	function ccc()
	{ return __CLASS__.'::'.__FUNCTION__.'()' ;}
}

function ccc(&$n,$m)
{ return $n*$m ;}


interface i
{
	public function dd() ;
	public function ddd() ;
}

abstract class d implements i
{
	public function dd(){}
}

class e extends d implements i
{
	public function dd(){}
	public function ddd(){}	
	
	public $n = 10 ;
}


class kk
{
	function kk(array $arrN, e $aM)
	{
		$this->arrN = $arrN ;
		$this->aM = $aM ;
	}
	
	public $arrN ;
	public $aM ;
}


// Call JCAT_GlobalTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_GlobalTest::main')
	JCAT_GlobalTest::main();
?>
