<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_LanguagePackageForClient.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * 语言包
 *
 * @author		alee
 * @access		public
 */
class JCAT_LanguagePackageForClient
	implements JCAT_ISSMI 
{
	
	/**
	 * 查询一个静态方法 是否在 HTTP 上公开
	 * 
	 * @access	public
	 * @param	$sMethodName	string	What's this Parameter ?
	 * @return	bool
	 */
	static public function IsPublicOnHTTP( $sMethodName )
	{
		return in_array( strtolower($sMethodName), array(
				'getlanguagepackage'
				, 'setnewsentence')
		);
	}

	/**
	 * 向提供一个语言包
	 *
	 * @access	public
	 * @param	$sLanguageName	string
	 * @param	$sPackageName		string
	 * @param	$bRefresh=false		bool
	 * @return	void
	 */
	public function GetLanguagePackage($sLanguageName,$sPackageName,$bRefresh=false)
	{
		// 取得 请求的语言包
		$thePackage = JCAT_LanguagePackage::GetPackage($sLanguageName,$sPackageName) ;
		if( !$thePackage )
		{
			return ;
		}
		
		header('Content-type: text/html; charset='.strtolower(JCAT::$CHARSET_PROJECT)) ;
		
		// 检查客户端缓存是否可用
		if(!$bRefresh)
		{
			$nThisClassMTime = filemtime(__FILE__) ;
			$nPackageFileMTime = $thePackage->GetUpdateTime() ;
			$nMTime = ($nPackageFileMTime>$nThisClassMTime)? $nPackageFileMTime: $nThisClassMTime ;
			if( JCAT_DownloadFile::VerifyClientCache($nMTime) )
			{
				return ;
			}
		}
		
		// 向客户端传送语言包内容
		print '{' ;
		
		$aIterator = $thePackage->CreateSentenceIterator() ;
		$aIterator->First() ;
		$nLine = 0 ;
		while( !$aIterator->IsDone() )
		{
			if($nLine++)
			{
				print ',' ;
			}
			
			print '"'.$aIterator->CurrentKey().'"' ;
			print ':' ;
			print '"'.$aIterator->Current().'"' ;
						
			$aIterator->Next() ;
		}

		print '}' ;
	}

	/**
	 * 保存一个来自Client的新语句
	 *
	 * @access	public
	 * @param	$sSentence			string
	 * @param	$sLanguageName	string
	 * @param	$sPackageName		string
	 * @return	void
	 */
	public function SetNewSentence($sSentenceKey,$sSentence,$sLanguageName,$sPackageName)
	{
		// 取得 请求的语言包
		$thePackage = JCAT_LanguagePackage::GetPackage($sLanguageName,$sPackageName) ;
		if( !$thePackage )
		{
			print JCAT_Language::SentenceEx('无法找到指定的语言包.语言:%s, 包:%s','JCAT',null,$sLanguageName,$sPackageName) ;
			return ;
		}
		
		// 语句 Key
		$thePackage->Set($sSentenceKey,$sSentence) ;
		
		print '1' ;
	}
}

/*macro_exception_code:0*/
?>