<?
/*-- Project Introduce --*/


/**
 * 用于管理 class(interface) 的加载
 *
 * @author		alee
 * @access		public
 */
class JCAT_ClassPackage
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_ClassPackage($sPath)
	{
		if( !is_dir($sPath) )
		{
			throw new JCAT_Exception("the directory path invalid:{$sPath}") ;
		}
		
		$this->sPath = realpath($sPath).'/' ;
		$this->AddClassFilenameParser(array(__CLASS__,'ParseFilename'));
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function __sleep()
	{
		return array(
			JCAT_Class::MakePrivateNameForSerialize('arrClassesPath',__CLASS__)
		) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sClassname
	 * @return	string
	 */
	public function QueryClass($sClassname)
	{
		return isset($this->arrClassesPath[$sClassname])?
				$this->GetPath().$this->arrClassesPath[$sClassname]: null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateClassNameIter()
	{
		return new JCAT_ArrayIterator(array_keys($this->arrClassesPath)) ; 
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetPath()
	{
		return $this->sPath ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parser		callback
	 * @return	void
	 */
	public function AddClassFilenameParser($Parser)
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Parser,array('callback'));
		$this->arrClassFilenameParser[] = $Parser ;
	}

	/**
	 * 注册 类-类文件
	 * 
	 * @access	public
	 * @param	$sClass				string		what's this
	 * @param	$sSubPath			string		what's this
	 * @return	void
	 */
	public function RegisterClass($sClass,$sSubPath)
	{
		if( !is_string($sClass) )
		{
			exit( JCAT_Language::SentenceEx('参数 $sClass 必须是一个字符串格式的类名','JCAT',null,$sClass) ) ;
		}

		$this->arrClassesPath[$sClass] = $sSubPath ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassesPathFile()
	{
		return $this->GetPath().$this->sClassesPathFilename ;
	}
	
	/**
	 * 载入类文件清单
	 * 
	 * @access	public
	 * @param 	$bForceRefreshCache=false
	 * @return	void
	 */
	public function LoadClassList($bForceRefreshCache=false)
	{
		$sClassesPathFile = $this->GetClassesPathFile() ;
		if( !$bForceRefreshCache and is_file($sClassesPathFile) )
		{
			$sCacheContent = file_get_contents($sClassesPathFile) ;
			$arrClassesFile = unserialize($sCacheContent) ;
			if( is_array($arrClassesFile) )
			{
				$this->arrClassesPath = $arrClassesFile ;
				return ;
			}
		}
		
		
			$this->_ScanClass($this->GetPath(),'') ;
			$this->SaveCache() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SaveCache()
	{		
		file_put_contents(
			$this->GetClassesPathFile()
			, serialize($this->arrClassesPath) 
		) ;
	}

	/**
	 * 扫描目录下的类
	 * 
	 * @access	private
	 * @param	$sDirectory			string		what's this
	 * @return	void
	 */
	private function _ScanClass($sDirectory,$sSubPath)
	{
		if($sDirectory===null)
		{
			$sDirectory = $this->GetPath() ;
		}
		
		// 整理 路径为统一格式
		$sDirectoryPath = realpath($sDirectory).'/' ;

		// 
		$hDir = opendir($sDirectoryPath) ;
		JCAT_ASSERT::ASSERT_($hDir,JCAT_Language::SentenceEx('无效的路径($sDirectory)：%s','JCAT',null,$sDirectory)) ;
		
		while( $sFilename=readdir($hDir) )
		{
			$sPath = $sDirectoryPath.$sFilename ;
			
			// 文件
			if(is_file($sPath))
			{
				foreach ($this->arrClassFilenameParser as $Parser)
				{
					$sClassName = call_user_func_array($Parser,array($sFilename)) ;
					if($sClassName)
					{
						$this->RegisterClass($sClassName,$sSubPath.$sFilename );						
						break ;
					}
				}
			}
			
			// 目录
			else if( is_dir($sPath) )
			{
				// 排除特殊目录
				if(in_array($sFilename,array('.','..','.svn')))
				{
					continue ;
				}
				
				// 递归子目录
				else
				{
					$this->_ScanClass($sPath,$sSubPath.$sFilename.'/') ;
				}
			}
			
			else
			{
				JCAT_ASSERT::ASSERT_(0,"what's this: {$sPath} ?")  ;
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sFilename
	 * @static 
	 * @return	string
	 */
	static public function ParseFilename($sFilename)
	{
		foreach (self::$arrClassFileRegexpPatterns as $sRegexp)
		{
			// 找到 类文件
			$arrRes = array() ;
			if( preg_match($sRegexp,$sFilename,$arrRes) )
			{
				if( isset($arrRes[1]) )
				{
					return $arrRes[1] ;
					//return str_replace('_','\\',$arrRes[1]) ;
				}
			}
		}
		
		return null ;
	}
	
	static private $arrClassFileRegexpPatterns = array(
			'/^class\.(.+)\.php$/i'
			, '/^interface\.(.+)\.php$/i'
	) ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrClassFilenameParser = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrClassesPath = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sClassesPathFilename = 'ClassesPath.serialize' ;
}

?>