<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_SSMI.php 1881 2009-05-29 07:50:07Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

class JCAT_SSMI extends JCAT_Controller implements JCAT_IHTTPPublicController 
{
	/**
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_SSMI()
	{
		$this->JCAT_Controller(__CLASS__) ;
	}
	
	/**
	 * @see JCAT_IController::MainRun()
	 *
	 */
	public function MainRun()
	{
		// 参数
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['Class']), JCAT_Language::SentenceEx('缺少参数 Class','JCAT',null) ) ;
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['Method']), JCAT_Language::SentenceEx('缺少参数 Method','JCAT',null) ) ;
		
		// JCAT_ISSMI 接口
		JCAT_ASSERT::ASSERT_ISCLASS($_REQUEST['Class'],array('JCAT_ISSMI')
				, JCAT_Language::SentenceEx('参数 Class 必须为实现 JCAT_ISSMI 接口的类名。','JCAT',null));
		
		// 是否可访问
		JCAT_ASSERT::ASSERT_(is_callable(array($_REQUEST['Class'],$_REQUEST['Method']),false)
				, JCAT_Language::SentenceEx('参数Method(%s) 必须为 参数Class(%s) 中可访问的静态方法。','JCAT',null,$_REQUEST['Method'],$_REQUEST['Class']));
		
		// 检查是否为HTTP公开方法
		$bPublic = call_user_func_array(array($_REQUEST['Class'],'IsPublicOnHTTP'),array($_REQUEST['Method'])) ;
		JCAT_ASSERT::ASSERT_($bPublic, JCAT_Language::SentenceEx('参数Method 必须在 %s::IsPublicOnHTTP() 中申明为可公开的方法。','JCAT',null,$_REQUEST['Class']));
		
		if( !isset($_REQUEST['Param']) )
		{
			$_REQUEST['Param'] = array() ;
		}
		
		// 调用
		call_user_func_array(array($_REQUEST['Class'],$_REQUEST['Method']),$_REQUEST['Param']) ;

		// 退出请求，以免后文干扰输出
		exit() ;
	}

}

?>