<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT
{


	/**
	 * 将 $sString 中的字串从项目字符集 转换 到服务器字符集
	 * <需要 mbstring 模块的支持!>
	 * 
	 * @access	public
	 * @param	$sString	string	用于转换的字串
	 * @static
	 * @return	string or null
	 */
	static public function CharsetToServer( $sString )
	{
		if( !function_exists( 'mb_convert_encoding' ) )
			return null ;

		if( self::$CHARSET_SERVER!==self::$CHARSET_PROJECT )
			return mb_convert_encoding($sString,self::$CHARSET_SERVER,self::$CHARSET_PROJECT) ;
		else
			return $sString ;
	}



	/**
	 * 将 $sString 中的字串从服务器字符集 转换 到项目字符集
	 * <需要 mbstring 模块的支持!>
	 * 
	 * @access	public
	 * @param	$sString	string	用于转换的字串
	 * @static
	 * @return	string or null
	 */
	static public function CharsetToProject( $sString ) 
	{
		if( !function_exists( 'mb_convert_encoding' ) )
			return null ;

		if( self::$CHARSET_SERVER!==self::$CHARSET_PROJECT )
			return mb_convert_encoding($sString,self::$CHARSET_PROJECT,self::$CHARSET_SERVER) ;
		else
			return $sString ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	const
	 * @var		
	 */
	const VERTION = '0.3.0' ;

	/**
	 * What's this Attribute ?
	 * 
	 * @access	const
	 * @var		
	 */
	const PACKAGE_LIBPHP = 1 ;
	const PACKAGE_APP = 2 ;
	const PACKAGE_COMMON = 3 ;
	const PACKAGE_MVC = 4 ;
	const PACKAGE_ADVANCE = 5 ;
	const PACKAGE_BACKTRACE = 6 ;
	const PACKAGE_DEBUG = 7 ;
	const PACKAGE_LANG = 8 ;
	const PACKAGE_PATTERN = 9 ;
	const PACKAGE_REQUEST = 10 ;
	const PACKAGE_DATASTRUCT = 11 ;
	const PACKAGE_FS = 12 ;
	const PACKAGE_DB = 13 ;
	const PACKAGE_UI = 14 ;
	const PACKAGE_DBFACTORY = 15 ;
	const PACKAGE_DBOBJECT = 16 ;
	const PACKAGE_DBCONNECT = 17 ;
	const PACKAGE_DBSQL = 18 ;
	const PACKAGE_DBRECORDSET = 19 ;
	const PACKAGE_DBSUBSQL = 20 ;
	const PACKAGE_UIGTK = 21 ;
	const PACKAGE_UIHTML = 22 ;
	const PACKAGE_UIHTMLPARSER = 23 ;
	const PACKAGE_UIHTMLCOMPILER = 24 ;
	const PACKAGE_UIHTMLCODECOMPILER = 25 ;
	const PACKAGE_UIHTMLNODECOMPILER = 26 ;
	const PACKAGE_CACHE = 27 ;
	const PACKAGE_UIGTKCOMPILER = 28 ;
	const PACKAGE_MVCGTK = 29 ;
	const PACKAGE_MVCHTML = 30 ;
	const PACKAGE_MVCDV = 31 ;
	const PACKAGE_DOC = 32 ;
	const PACKAGE_UICTRLGTK = 33 ;
	const PACKAGE_UICTRLHTML = 34 ;
	const PACKAGE_MSG = 35 ;

	const PACKAGE_UICTRLHTMLBASE= 36 ;
	const PACKAGE_UICTRLHTMLADV = 37 ;

	
	/**
	 * 项目类型：命令行
	 * 
	 * @access	public
	 * @var		
	 * @const
	 */
	const TYPE_COMMANDLINE = 1 ;
	
	/**
	 * 项目类型：桌面
	 * 
	 * @access	const
	 * @var		
	 */
	const TYPE_DESKTOP = 3 ;
	
	/**
	 * 项目类型：HTML
	 * 
	 * @access	const
	 * @var		
	 */
	const TYPE_HTML = 4 ;
	
	static public $TYPE = self::TYPE_HTML ;
	
	/**
	 * JCAT框架的顶级目录
	 * 
	 * @access	const
	 * @var		
	 */
	//static public $LIB_ROOT = '' ;
	
	/**
	 * 项目 顶级目录
	 * 
	 * @access	const
	 * @var		
	 */
	//static public $PROJECT_ROOT = '' ;

	/**
	 * 项目字符集
	 * 
	 * @access	public
	 * @var		
	 * @static
	 */
	static public $CHARSET_SERVER = 'UTF-8' ;

	/**
	 * 服务器字符集
	 * 
	 * @access	public
	 * @var		
	 * @static
	 */
	static public $CHARSET_PROJECT = 'UTF-8' ;


}
?>