<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Exception.php 1962 2009-08-15 12:09:55Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

// 

// 声明缺省的 异常 ID
define('__macro_exception_code__',0) ;


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_Exception extends Exception
{


	/**
	 * JCAT异常
	 * 
	 * @access	public
	 * @param	$sMsg=''	string	异常消息
	 * @param	$nCode		int		JCAT统一异常ID，是一个2进制24位整数，左八位代表包ID，左16位代表Class ID，右8位代表异常ID
	 * @return	void
	 */
	public function JCAT_Exception( $sMsg='', $nCode=0 ) 
	{
		if(!$sMsg)
		{
			$sMsg = '' ;
		}

		Exception::__construct($sMsg,$nCode) ;
		
		
		if( !$this->aDefaultProcessor )
		{
			switch (JCAT::$TYPE)
			{					
				case JCAT::TYPE_HTML :
					$this->aDefaultProcessor = new JCAT_ExceptionProcessorHtml($this) ;
					break ;
					
				case JCAT::TYPE_DESKTOP :
					$this->aDefaultProcessor = new JCAT_ExceptionProcessorGtk($this) ;
					break ;
					
				// JCAT::TYPE_COMMANDLINE 
				default:
					$this->aDefaultProcessor = new JCAT_ExceptionProcessorCMD($this) ;
					break ;
			}
		}	
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetMsg(  ) 
	{ return $this->getMessage() ; }



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	
	 */
	public function GeBacktrace(  ) 
	{
		// Todo Samething ... ...
		// ... ...
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	
	 */
	public function GetExceptionPoint(  ) 
	{
		// Todo Samething ... ...
		// ... ...
	}
	
	/**
	 * 返回触发异常的包ID
	 * 
	 * @access	public
	 * @return	
	 */
	public function GetPackageID()
	{
		$nCode = $this->GetCode() ;
		return ($nCode>>16) ;
	}
	
	/**
	 * 返回触发异常的类ID
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetClassID()
	{
		$nCode = $this->GetCode() ;
		return (($nCode>>8)&255) ;
	}
	
	/**
	 * 返回触发异常的类名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetClassName()
	{
		$nClassID = $this->GetClassID() ;
		return JCAT_Package::GetClassByID($nClassID) ;
	}


	/**
	 * 取得该异常缺省的异常处理器。
	 * 如果没有任何 catch 处理此异常，JCAT 会访问此方法获得一个异常处理器并执行
	 *
	 * @access	public
	 * @return	JCAT_IController
	 */
	public function GetDefaultProcessor()
	{
		return $this->aDefaultProcessor ;
	}
	
	/**
	 * 设置该异常缺省的异常处理器。
	 * 如果没有任何 catch 处理此异常，JCAT 会访问此方法获得一个异常处理器并执行
	 *
	 * @access	public
	 * @return	JCAT_IController
	 */
	public function SetDefaultProcessor(JCAT_IController $aProcessor)
	{
		$this->aDefaultProcessor = $aProcessor ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Class					int,string	What's this Parameter ?
	 * @param	$nExceptionNumInClass	int	What's this Parameter ?
	 * @static
	 * @return	int
	 */
	static public function MakeExceptionCode( $Class, $nExceptionNumInClass ) 
	{
		if( is_string($Class) )
		{
			if( !defined($Class) )
			{
				return 0 ;
				throw new JCAT_Exception("Class ID Constant: {$Class} is not exists.",JCAT_Exception::MakeExceptionCode(__CLASS__,1)) ;
			}
			else 
			{
				$Class = constant($Class) ;
			}
		}
		return ($Class<<8)|$nExceptionNumInClass ;
	}



	/**
	 * 缺省异常处理函数
	 * 系统中未被俘获的异常统一由此函数处理
	 * 
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function ProcessUncaughtException(Exception $aException) 
	{
		$aDefaultProcessor = JCAT_Global::IsKindOf($aException,__CLASS__) ?
			$aException->GetDefaultProcessor(): null ;
		
		if( !$aDefaultProcessor or !JCAT_Global::HasImplementedTo($aDefaultProcessor,'JCAT_IController') )
		{
			$aDefaultProcessor = new JCAT_ExceptionProcessorHtml($aException) ;
		}
		
		$aDefaultProcessor->MainRun() ;
	}

	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IController
	 */
	private $aDefaultProcessor ;
}

/*macro_exception_code:1*/
?>