<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ControllerOutputBuffer.php 1619 2009-04-02 02:52:19Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_ControllerOutputBuffer implements JCAT_IController
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aController	JCAT_IController	What's this Parameter ?
	 * @return	void
	 */
	public function JCAT_ControllerOutputBuffer( JCAT_IController $aController ) 
	{
		$this->aController = $aController ;
		self::$arrBuffers[$aController->GetName()] = $this ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$arrArgs	array
	 * @return	mixed
	 */
	public function MainRun(array $arrArgs=array())
	{		
		// 开始
		ob_start() ;
		
		// 执行控制器
		try{
			$Ret = $this->aController->MainRun($arrArgs) ;
		}
		
		// 遇到异常，停止 OB，以便输出异常信息
		catch (Exception $aException)
		{	
			$this->EndHoldOn() ;
			throw $aException ;
		}
		catch (ErrorException $aException)
		{	
			$this->EndHoldOn() ;
			throw $aException ;
		}
		
		// 关闭
		$this->EndHoldOn() ;
		
		return $Ret ;
	}
	
	private function EndHoldOn()
	{
		$this->sBuffer = ob_get_contents() ;
		ob_end_clean() ;
	}
	
	/**
	 * 输出缓存内容
	 *
	 * @access	public
	 * @param	$bClean=true		bool
	 * @return	void
	 */
	public function PrintBuffer($bClean=true)
	{
		print $this->sBuffer ;
		
		if($bClean)
		{
			$this->sBuffer = '' ;
		}
	}
	
	/**
	 * 取得缓存内容
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetBuffer()
	{
		return $this->sBuffer ;
	}
	
	/**
	 * 根据控制器的名称 取得Buffer
	 *
	 * @access	public
	 * @param	$sControllerName
	 * @static
	 * @return	JCAT_ControllerOutputBuffer
	 */
	static public function GetBufferByName($sControllerName)
	{
		if( isset(self::$arrBuffers[$sControllerName]) )
		{
			return self::$arrBuffers[$sControllerName] ;
		}
		
		else
		{
			return null ;
		}
	}

	// 属性 ////////////////////////////////////////////////
	
	private $aController ;
	
	private $sBuffer ;
	
	static private $arrBuffers = array() ;
	
	// 实现 JCAT_IController 接口
	// ------------------------------------------	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_IController
	 */
	public function GetParentController()
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}


	/**
	 * 取回 顶级控制器
	 * 
	 * @access	public
	 * @return	JCAT_IController
	 */
	public function GetTopController()
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetName(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}


	/**
	 * 设置消息队列
	 *
	 * @access	public
	 * @param	$aMessageQueue		JCAT_MessageQueue	What's this Parameter ?
	 * @return	old_value
	 */
	public function SetMessageQueue( JCAT_MessageQueue $aMessageQueue )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	/**
	 * 取得 消息队列
	 *
	 * @access	public
	 * @return	JCAT_MessageQueue, null
	 */
	public function GetMessageQueue()
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	/**
	 * 彻底 销毁一个控制器 在  MVC 系统中的所有引用，以便在不需要该控制器时能够立刻回收：
	 *  父控制器 对该控制器的引用
	 *  视图 对该控制器的引用
	 *  ... ...
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Destroy()
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aController	JCAT_IController	What's this Parameter ?
	 * @param	$sName=null		string				What's this Parameter ?
	 * @return	void
	 */
	public function AddController(  JCAT_IController $aController, $sName=null )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	JCAT_IController
	 */
	public function GetController( $sName )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName		What's this Parameter ?
	 * @return	void
	 */
	public function RemoveController(  $sName )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetCotronllorCount(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearCotronllor(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateControllerIterator(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	array
	 */
	public function CreateControllerMemento(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	array $arrMemento		What's this Parameter ?
	 * @return	void
	 */
	public function SetControllerMemento(  array $arrMemento )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	
	// 实现 JCAT_IViewContainer 的方法
	// ----------------------------------------------

	public function AddView( JCAT_IView $aViewComponent, $sName=null )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	public function RemoveView( $ViewComponent )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	public function GetView( $sName, $bRecursion=false )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	public function GetViewCount(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	public function ClearView(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	public function CreateViewIterator(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	public function CreateViewMemento(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}

	public function SetViewMemento( $arrMemento )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	
	// 实现 JCAT_IModelContainer 的方法
	// ----------------------------------------------
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aDoc		JCAT_IModel	What's this Parameter ?
	 * @param	$sName=null	string			What's this Parameter ?
	 * @return	void
	 */
	public function AddModel( JCAT_IModel $aDoc, $sName=null )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_IModel	What's this Parameter ?
	 * @return	void
	 */
	public function RemoveModel( JCAT_IModel $aModel )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	JCAT_IModel
	 */
	public function GetModel( $sName )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetModelCount(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearModel(  ) 
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateModelIterator(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	array
	 */
	public function CreateModelMemento(  )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$arrMemento	What's this Parameter ?
	 * @return	array
	 */
	public function SetModelMemento( $arrMemento )
	{
		$arrArgs = func_get_args() ;
		return call_user_func_array(array($this->aController,__FUNCTION__),$arrArgs) ;
	}
	
	/**
	 * 设置一个用于维护请求参数的对象
	 *
	 * @access	public
	 * @param	$sRequest		JCAT_Request	用户请求
	 * @return	void
	 */
	public function SetRequest(JCAT_Request $sRequest)
	{
		return $this->aController->SetRequest($sRequest) ;
	}
	
	/**
	 * 取得用于维护请求参数的对象
	 *
	 * @access	public
	 * @return	JCAT_Request
	 */
	public function GetRequest()
	{
		return $this->aController->GetRequest() ;
	}
}

?>