<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IController.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IController extends JCAT_IViewContainer, JCAT_IModelContainer
{	
	/**
	 * 设置一个用于维护请求参数的对象
	 *
	 * @access	public
	 * @param	$sRequest		JCAT_Request	用户请求
	 * @return	void
	 */
	public function SetRequest(JCAT_Request $sRequest) ;
	
	/**
	 * 取得用于维护请求参数的对象
	 *
	 * @access	public
	 * @return	JCAT_Request
	 */
	public function GetRequest() ;
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_IController
	 */
	public function GetParentController(  )  ;


	/**
	 * 取回 顶级控制器
	 * 
	 * @access	public
	 * @return	JCAT_IController
	 */
	public function GetTopController() ;

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetName(  )  ;


	/**
	 * 设置消息队列
	 *
	 * @access	public
	 * @param	$aMessageQueue		JCAT_MessageQueue	What's this Parameter ?
	 * @return	old_value
	 */
	public function SetMessageQueue( JCAT_MessageQueue $aMessageQueue ) ;
	
	/**
	 * 取得 消息队列
	 *
	 * @access	public
	 * @return	JCAT_MessageQueue, null
	 */
	public function GetMessageQueue() ;

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun(  )  ;
	

	/**
	 * 彻底 销毁一个控制器 在  MVC 系统中的所有引用，以便在不需要该控制器时能够立刻回收：
	 *  父控制器 对该控制器的引用
	 *  视图 对该控制器的引用
	 *  ... ...
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Destroy() ;
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aController	JCAT_IController	What's this Parameter ?
	 * @param	$sName=null		string				What's this Parameter ?
	 * @return	void
	 */
	public function AddController(  JCAT_IController $aController, $sName=null ) ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	JCAT_IController
	 */
	public function GetController( $sName )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName		What's this Parameter ?
	 * @return	void
	 */
	public function RemoveController(  $sName )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetCotronllorCount(  )  ;
	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearCotronllor(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateControllerIterator(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	array
	 */
	public function CreateControllerMemento(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	array $arrMemento		What's this Parameter ?
	 * @return	void
	 */
	public function SetControllerMemento(  array $arrMemento )  ;




	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>