<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlLengthVerifier.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * 数据長度校验
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlLengthVerifier
		implements JCAT_IUICtrlVerifier, JCAT_IFlyweight, JCAT_IUICtrlHtmlVerifier
{
	/**
	 * 
	 * @access	public
	 * @param	$nMin=-1			int		最小長度
	 * @param	$nMax=-1			int		最大長度
	 * @param	$bAllowEmpty=true	bool	是否允许为空
	 * @return	void
	 */
	public function JCAT_UICtrlLengthVerifier( $nMin=-1, $nMax=-1, $bAllowEmpty=true ) 
	{
		$this->nMin = $nMin ;
		$this->nMax = $nMax ;
		$this->bAllowEmpty = $bAllowEmpty ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Paramer1		What's this Parameter ?
	 * @static
	 * @return	string
	 */
	static public function GetFlyweightKey(  /*$Paramer1,  ...n*/ ) 
	{
		
		JCAT_ASSERT::ASSERT_(func_num_args()==3,JCAT_Language::SentenceEx(__CLASS__.'::'.__FUNCTION__."()的参数数量必须为3",'JCAT',null)) ;
		list($nMin,$nMax,$bAllowEmpty) = func_get_args() ;
		
		JCAT_ASSERT::ASSERT_INT($nMin) ;
		JCAT_ASSERT::ASSERT_INT($nMax) ;
		JCAT_ASSERT::ASSERT_BOOL($bAllowEmpty) ;
		
		return "{$nMin}-{$nMax}:" . ($bAllowEmpty? 'TRUE': 'FALSE') ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUICtrl				JCAT_IUICtrlForm	What's this Parameter ?
	 * @return	bool
	 */
	public function VerifyData( JCAT_IUICtrlForm $aUICtrl )
	{
		$nDataLen = $aUICtrl->GetDataLength() ;
		
		// 内容为空
		if( $nDataLen==0 )
		{
			if( !$this->bAllowEmpty  )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('栏位“%s”未输入任何内容，该栏位不允许为空。','JCAT',null,$aUICtrl->GetUIName()),MSGMVC_BAD) ;
				return false ;
			}
			
			else 
			{
				return true ;
			}
		}
		
		if( $this->nMin>=0 and $this->nMin>$nDataLen )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('栏位“%s”输入内容的长度不应小于 %d，输入长度为 %d。','JCAT',null,$aUICtrl->GetUIName(),$this->nMin,$nDataLen),MSGMVC_BAD) ;
			return false ;
		}
		
		if( $this->nMax>=0 and $this->nMax<$nDataLen )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('栏位“%s”输入内容的长度不应大于 %d，输入长度为 %d。','JCAT',null,$aUICtrl->GetUIName(),$this->nMax,$nDataLen),MSGMVC_BAD) ;
			return false ;
		}
		
		return true ;
	}


	/**
	 * 创建 JS 数据校验器对象
	 * 
	 * @access	public
	 * @param	$sJSVariableName	string	What's this Parameter ?
	 * @return	string
	 */
	public function CreateJSVerifier($sJSVariableName)
	{
		$sAllowEmpty = $this->bAllowEmpty? 'true': 'false' ;
		return "{$sJSVariableName} = new JCAT.MVC.DataVerifier.LengthVerifier({$this->nMin},{$this->nMax},{$sAllowEmpty})" ;
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	private $nMin = -1 ;
	
	private $nMax = -1 ;
	
	private $bAllowEmpty = true ;
}


?>