<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlNumberVerifier.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_UICtrlNumberVerifier implements JCAT_IUICtrlVerifier, JCAT_IFlyweight
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$bOnlyInt=true	bool	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetOnlyInteger( $nNUMTYPE=self::NUMTYPE_ALL ) 
	{
		$this->nNUMTYPE = $nNUMTYPE ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function AllowInteger() 
	{
		return ($this->nNUMTYPE&self::NUMTYPE_INT) ;
	}
	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function AllowFloat() 
	{
		return ($this->nNUMTYPE&self::NUMTYPE_FLOAT) ;
	}
	


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$Paramer1		What's this Parameter ?
	 * @static
	 * @return	string
	 */
	static public function GetFlyweightKey(  /*$Paramer1,  ...n*/ ) 
	{
		JCAT_ASSERT::ASSERT_(func_num_args()==1,JCAT_Language::SentenceEx(__CLASS__.'::'.__FUNCTION__."()的参数数量必须为1",'JCAT',null)) ;
		list($nNumType) = func_get_args() ;
		
		switch($nNumType)
		{
			case self::NUMTYPE_NaN :
				return 'NUMTYPE_NaN' ;

			case self::NUMTYPE_INT :
				return 'NUMTYPE_INT' ;
				
			case self::NUMTYPE_FLOAT :
				return 'NUMTYPE_FLOAT' ;
				
			case self::NUMTYPE_ALL :
				return 'NUMTYPE_ALL' ;
				
			default:
				JCAT_ASSERT::ASSERT_(0,'!?');
				return 0 ;
		}
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aUICtrl				JCAT_IUICtrlForm	What's this Parameter ?
	 * @return	bool
	 */
	public function VerifyData( JCAT_IUICtrlForm $aUICtrl )
	{
		$Value = $aUICtrl->GetExchangeData();
		if( $Value===JCAT_Model::NULL_DATA_VALUE )
		{
			return true ;
		}
				
		// 数字类型
		if( is_numeric($Value) )
		{
			$nType = is_integer($Value)? self::NUMTYPE_INT: self::NUMTYPE_FLOAT ;
		}
		
		// 字符串
		else if( is_string($Value) )
		{
			if($Value==='')
			{
				return true ;
			}
			if( preg_match('/^\d+(\.\d+)?$/',$Value,$arrRet) )
			{
				$nType = $arrRet[1]? self::NUMTYPE_INT: self::NUMTYPE_FLOAT ;
			}
			else
			{
				$nType = self::NUMTYPE_NaN ;
			}
			// $nValue = intval($Value) ;
		}
		
		// 其他类型
		else
		{
			$nType = self::NUMTYPE_NaN ;
		}
		
		// 判断
		if ($nType===self::NUMTYPE_INT)
		{
			if( !$this->AllowInteger() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('栏位“%s”输入的内容不能为整数形式。；输入值为:%s','JCAT',null,$aUICtrl->GetUIName(),$Value),MSGMVC_BAD) ;
				return false ;
			}
		}
		elseif ($nType===self::NUMTYPE_FLOAT)
		{
			if( !$this->AllowFloat() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('栏位“%s”输入的内容不能为小数形式；输入值为:%s','JCAT',null,$aUICtrl->GetUIName(),$Value),MSGMVC_BAD) ;
				return false ;
			}
		}
		elseif ($nType===self::NUMTYPE_NaN)
		{		
			if( $this->AllowFloat() or $this->AllowInteger() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('栏位“%s”输入的内容必须为数字形式；输入值为:%s','JCAT',null,$aUICtrl->GetUIName(),$Value),MSGMVC_BAD) ;
				return false ;
			}
		}
		else
			return false ;
		
			
		return true ;
	}
	


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	const NUMTYPE_NaN = 0 ;
	const NUMTYPE_INT = 1 ;
	const NUMTYPE_FLOAT = 2 ;
	const NUMTYPE_ALL = 3 ;
	
	
	private $nNUMTYPE = self::NUMTYPE_ALL ;
	
	
	
}

?>