<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UICtrlGtkBase.php 1843 2009-05-19 13:17:03Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_UICtrlGtkBase extends JCAT_UICtrlBase implements JCAT_IUICtrlGtk
{

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName				string						控件名称
	 * @param	$sUIName			string						控件UI名称
	 * @param	$Widget				GtkWidget,string			控件主窗体 或 主窗体ID
	 * @return	void
	 */
	public function JCAT_UICtrlGtkBase( $sName, $sUIName, GtkWidget $wndWidget )
	{
		JCAT_ASSERT::ASSERT_STRING($sName);
		JCAT_ASSERT::ASSERT_STRING($sUIName);
		
		// 名称
		$this->SetName($sName,$sUIName) ;
		
		// 窗体
		$this->sMainWidgetId = $wndWidget->get_name() ;
		$this->SetMainWidget($wndWidget) ;
	}

	/**
	 * 设置一个Gtk窗体，将 UI控件 和 Gtk窗体 绑定
	 * 
	 * @access	protected
	 * @param	$wndWidget=null	GtkWidget	控件主窗体
	 * @return	old_value
	 */
	protected function SetMainWidget(GtkWidget $wndMainWidget=null) 
	{
		$old_value = $this->wndMainWidget ;
		$this->wndMainWidget = $wndMainWidget ;
		return $old_value ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	GtkWidget
	 */
	public function GetMainWidget() 
	{
		return $this->wndMainWidget ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$bShow=true	bool	What's this Parameter ?
	 * @return	
	 */
	public function SetShow( $bShow=true ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($this->wndMainWidget,'GtkWidget',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
		$this->wndMainWidget->set_visible($bShow) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$bEnable=true	bool	What's this Parameter ?
	 * @return	
	 */
	public function SetEnable( $bEnable=true ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($this->wndMainWidget,'GtkWidget',JCAT_Language::SentenceEx('UICtrl(%s) 的主窗口尚未初始化。','JCAT',null,$this->GetName())) ;
		
	}

	/**
	 * 
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetMainWidgetId()
	{
		return $this->sMainWidgetId ;
	}
		
	/**
	 * 设置 UI控件 是否已经改变
	 * 
	 * @access	public
	 * @param	$bChanged=true	bool			what's this
	 * @return	old_value
	 */
	public function SetUICtrlChanged($bChanged=true)
	{
		$old_value = $this->bChanged ;
		$this->bChanged = $bChanged? true: false ;
		return $old_value ;
	}
	
	/**
	 * 查询 UI控件 是否已经改变
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsUICtrlChanged()
	{
		return $this->bChanged ;
	}
	
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sMainWidgetId ;
	
	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		GtkWidget
	 */
	private $wndMainWidget ;

	
	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		GtkWidget
	 */
	private $aUICtrlChangedEmitedObject ;

	
	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		handle
	 */
	private $hUICtrlChangedFunction ;
	
	private $bChangedEvent = true ;
	
	
	private $bChanged = false ;
	
}
?>